package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait CertificateStatusType {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.CertificateStatusType
}
object CertificateStatusType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.CertificateStatusType
  ): zio.aws.transfer.model.CertificateStatusType = value match {
    case software.amazon.awssdk.services.transfer.model.CertificateStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.CertificateStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.transfer.model.CertificateStatusType.PENDING_ROTATION =>
      val r = PENDING_ROTATION
      r
    case software.amazon.awssdk.services.transfer.model.CertificateStatusType.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.CertificateStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateStatusType =
      software.amazon.awssdk.services.transfer.model.CertificateStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.transfer.model.CertificateStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateStatusType =
      software.amazon.awssdk.services.transfer.model.CertificateStatusType.ACTIVE
  }
  case object PENDING_ROTATION
      extends zio.aws.transfer.model.CertificateStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateStatusType =
      software.amazon.awssdk.services.transfer.model.CertificateStatusType.PENDING_ROTATION
  }
  case object INACTIVE extends zio.aws.transfer.model.CertificateStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateStatusType =
      software.amazon.awssdk.services.transfer.model.CertificateStatusType.INACTIVE
  }
}
