package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait CertificateType {
  def unwrap: software.amazon.awssdk.services.transfer.model.CertificateType
}
object CertificateType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.CertificateType
  ): zio.aws.transfer.model.CertificateType = value match {
    case software.amazon.awssdk.services.transfer.model.CertificateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.CertificateType.CERTIFICATE =>
      val r = CERTIFICATE
      r
    case software.amazon.awssdk.services.transfer.model.CertificateType.CERTIFICATE_WITH_PRIVATE_KEY =>
      val r = CERTIFICATE_WITH_PRIVATE_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateType =
      software.amazon.awssdk.services.transfer.model.CertificateType.UNKNOWN_TO_SDK_VERSION
  }
  case object CERTIFICATE extends zio.aws.transfer.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateType =
      software.amazon.awssdk.services.transfer.model.CertificateType.CERTIFICATE
  }
  case object CERTIFICATE_WITH_PRIVATE_KEY
      extends zio.aws.transfer.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateType =
      software.amazon.awssdk.services.transfer.model.CertificateType.CERTIFICATE_WITH_PRIVATE_KEY
  }
}
