package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait CompressionEnum {
  def unwrap: software.amazon.awssdk.services.transfer.model.CompressionEnum
}
object CompressionEnum {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.CompressionEnum
  ): zio.aws.transfer.model.CompressionEnum = value match {
    case software.amazon.awssdk.services.transfer.model.CompressionEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.CompressionEnum.ZLIB =>
      val r = ZLIB
      r
    case software.amazon.awssdk.services.transfer.model.CompressionEnum.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.CompressionEnum {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CompressionEnum =
      software.amazon.awssdk.services.transfer.model.CompressionEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ZLIB extends zio.aws.transfer.model.CompressionEnum {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CompressionEnum =
      software.amazon.awssdk.services.transfer.model.CompressionEnum.ZLIB
  }
  case object DISABLED extends zio.aws.transfer.model.CompressionEnum {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CompressionEnum =
      software.amazon.awssdk.services.transfer.model.CompressionEnum.DISABLED
  }
}
