package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Message, FailureCode, FilePath}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectorFileTransferResult(
    filePath: FilePath,
    statusCode: zio.aws.transfer.model.TransferTableStatus,
    failureCode: Optional[FailureCode] = Optional.Absent,
    failureMessage: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult = {
    import ConnectorFileTransferResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult
      .builder()
      .filePath(FilePath.unwrap(filePath): java.lang.String)
      .statusCode(statusCode.unwrap)
      .optionallyWith(
        failureCode.map(value => FailureCode.unwrap(value): java.lang.String)
      )(_.failureCode)
      .optionallyWith(
        failureMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.failureMessage)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly =
    zio.aws.transfer.model.ConnectorFileTransferResult.wrap(buildAwsValue())
}
object ConnectorFileTransferResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ConnectorFileTransferResult =
      zio.aws.transfer.model.ConnectorFileTransferResult(
        filePath,
        statusCode,
        failureCode.map(value => value),
        failureMessage.map(value => value)
      )
    def filePath: FilePath
    def statusCode: zio.aws.transfer.model.TransferTableStatus
    def failureCode: Optional[FailureCode]
    def failureMessage: Optional[Message]
    def getFilePath: ZIO[Any, Nothing, FilePath] = ZIO.succeed(filePath)
    def getStatusCode
        : ZIO[Any, Nothing, zio.aws.transfer.model.TransferTableStatus] =
      ZIO.succeed(statusCode)
    def getFailureCode: ZIO[Any, AwsError, FailureCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult
  ) extends zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly {
    override val filePath: FilePath =
      zio.aws.transfer.model.primitives.FilePath(impl.filePath())
    override val statusCode: zio.aws.transfer.model.TransferTableStatus =
      zio.aws.transfer.model.TransferTableStatus.wrap(impl.statusCode())
    override val failureCode: Optional[FailureCode] = zio.aws.core.internal
      .optionalFromNullable(impl.failureCode())
      .map(value => zio.aws.transfer.model.primitives.FailureCode(value))
    override val failureMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => zio.aws.transfer.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ConnectorFileTransferResult
  ): zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly = new Wrapper(
    impl
  )
}
