package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ProfileId,
  ServerId,
  HomeDirectory,
  Description,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateAgreementRequest(
    description: Optional[Description] = Optional.Absent,
    serverId: ServerId,
    localProfileId: ProfileId,
    partnerProfileId: ProfileId,
    baseDirectory: HomeDirectory,
    accessRole: Role,
    status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateAgreementRequest = {
    import CreateAgreementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateAgreementRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .localProfileId(ProfileId.unwrap(localProfileId): java.lang.String)
      .partnerProfileId(ProfileId.unwrap(partnerProfileId): java.lang.String)
      .baseDirectory(HomeDirectory.unwrap(baseDirectory): java.lang.String)
      .accessRole(Role.unwrap(accessRole): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateAgreementRequest.ReadOnly =
    zio.aws.transfer.model.CreateAgreementRequest.wrap(buildAwsValue())
}
object CreateAgreementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateAgreementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateAgreementRequest =
      zio.aws.transfer.model.CreateAgreementRequest(
        description.map(value => value),
        serverId,
        localProfileId,
        partnerProfileId,
        baseDirectory,
        accessRole,
        status.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[Description]
    def serverId: ServerId
    def localProfileId: ProfileId
    def partnerProfileId: ProfileId
    def baseDirectory: HomeDirectory
    def accessRole: Role
    def status: Optional[zio.aws.transfer.model.AgreementStatusType]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getLocalProfileId: ZIO[Any, Nothing, ProfileId] =
      ZIO.succeed(localProfileId)
    def getPartnerProfileId: ZIO[Any, Nothing, ProfileId] =
      ZIO.succeed(partnerProfileId)
    def getBaseDirectory: ZIO[Any, Nothing, HomeDirectory] =
      ZIO.succeed(baseDirectory)
    def getAccessRole: ZIO[Any, Nothing, Role] = ZIO.succeed(accessRole)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.AgreementStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateAgreementRequest
  ) extends zio.aws.transfer.model.CreateAgreementRequest.ReadOnly {
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val localProfileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.localProfileId())
    override val partnerProfileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.partnerProfileId())
    override val baseDirectory: HomeDirectory =
      zio.aws.transfer.model.primitives.HomeDirectory(impl.baseDirectory())
    override val accessRole: Role =
      zio.aws.transfer.model.primitives.Role(impl.accessRole())
    override val status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.AgreementStatusType.wrap(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateAgreementRequest
  ): zio.aws.transfer.model.CreateAgreementRequest.ReadOnly = new Wrapper(impl)
}
