package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.AgreementId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAgreementResponse(agreementId: AgreementId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateAgreementResponse = {
    import CreateAgreementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateAgreementResponse
      .builder()
      .agreementId(AgreementId.unwrap(agreementId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateAgreementResponse.ReadOnly =
    zio.aws.transfer.model.CreateAgreementResponse.wrap(buildAwsValue())
}
object CreateAgreementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateAgreementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateAgreementResponse =
      zio.aws.transfer.model.CreateAgreementResponse(agreementId)
    def agreementId: AgreementId
    def getAgreementId: ZIO[Any, Nothing, AgreementId] =
      ZIO.succeed(agreementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateAgreementResponse
  ) extends zio.aws.transfer.model.CreateAgreementResponse.ReadOnly {
    override val agreementId: AgreementId =
      zio.aws.transfer.model.primitives.AgreementId(impl.agreementId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateAgreementResponse
  ): zio.aws.transfer.model.CreateAgreementResponse.ReadOnly = new Wrapper(impl)
}
