package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateConnectorResponse(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateConnectorResponse = {
    import CreateConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateConnectorResponse
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateConnectorResponse.ReadOnly =
    zio.aws.transfer.model.CreateConnectorResponse.wrap(buildAwsValue())
}
object CreateConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateConnectorResponse =
      zio.aws.transfer.model.CreateConnectorResponse(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateConnectorResponse
  ) extends zio.aws.transfer.model.CreateConnectorResponse.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateConnectorResponse
  ): zio.aws.transfer.model.CreateConnectorResponse.ReadOnly = new Wrapper(impl)
}
