package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait CustomStepStatus {
  def unwrap: software.amazon.awssdk.services.transfer.model.CustomStepStatus
}
object CustomStepStatus {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.CustomStepStatus
  ): zio.aws.transfer.model.CustomStepStatus = value match {
    case software.amazon.awssdk.services.transfer.model.CustomStepStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.CustomStepStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.transfer.model.CustomStepStatus.FAILURE =>
      val r = FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.CustomStepStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CustomStepStatus =
      software.amazon.awssdk.services.transfer.model.CustomStepStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.transfer.model.CustomStepStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CustomStepStatus =
      software.amazon.awssdk.services.transfer.model.CustomStepStatus.SUCCESS
  }
  case object FAILURE extends zio.aws.transfer.model.CustomStepStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CustomStepStatus =
      software.amazon.awssdk.services.transfer.model.CustomStepStatus.FAILURE
  }
}
