package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SourceFileLocation, WorkflowStepName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DecryptStepDetails(
    name: Optional[WorkflowStepName] = Optional.Absent,
    `type`: zio.aws.transfer.model.EncryptionType,
    sourceFileLocation: Optional[SourceFileLocation] = Optional.Absent,
    overwriteExisting: Optional[zio.aws.transfer.model.OverwriteExisting] =
      Optional.Absent,
    destinationFileLocation: zio.aws.transfer.model.InputFileLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DecryptStepDetails = {
    import DecryptStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DecryptStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .`type`(`type`.unwrap)
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .optionallyWith(overwriteExisting.map(value => value.unwrap))(
        _.overwriteExisting
      )
      .destinationFileLocation(destinationFileLocation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DecryptStepDetails.ReadOnly =
    zio.aws.transfer.model.DecryptStepDetails.wrap(buildAwsValue())
}
object DecryptStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DecryptStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DecryptStepDetails =
      zio.aws.transfer.model.DecryptStepDetails(
        name.map(value => value),
        `type`,
        sourceFileLocation.map(value => value),
        overwriteExisting.map(value => value),
        destinationFileLocation.asEditable
      )
    def name: Optional[WorkflowStepName]
    def `type`: zio.aws.transfer.model.EncryptionType
    def sourceFileLocation: Optional[SourceFileLocation]
    def overwriteExisting: Optional[zio.aws.transfer.model.OverwriteExisting]
    def destinationFileLocation
        : zio.aws.transfer.model.InputFileLocation.ReadOnly
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, Nothing, zio.aws.transfer.model.EncryptionType] =
      ZIO.succeed(`type`)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
    def getOverwriteExisting
        : ZIO[Any, AwsError, zio.aws.transfer.model.OverwriteExisting] =
      AwsError.unwrapOptionField("overwriteExisting", overwriteExisting)
    def getDestinationFileLocation
        : ZIO[Any, Nothing, zio.aws.transfer.model.InputFileLocation.ReadOnly] =
      ZIO.succeed(destinationFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DecryptStepDetails
  ) extends zio.aws.transfer.model.DecryptStepDetails.ReadOnly {
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val `type`: zio.aws.transfer.model.EncryptionType =
      zio.aws.transfer.model.EncryptionType.wrap(impl.`type`())
    override val sourceFileLocation: Optional[SourceFileLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFileLocation())
        .map(value =>
          zio.aws.transfer.model.primitives.SourceFileLocation(value)
        )
    override val overwriteExisting
        : Optional[zio.aws.transfer.model.OverwriteExisting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overwriteExisting())
        .map(value => zio.aws.transfer.model.OverwriteExisting.wrap(value))
    override val destinationFileLocation
        : zio.aws.transfer.model.InputFileLocation.ReadOnly =
      zio.aws.transfer.model.InputFileLocation
        .wrap(impl.destinationFileLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DecryptStepDetails
  ): zio.aws.transfer.model.DecryptStepDetails.ReadOnly = new Wrapper(impl)
}
