package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeConnectorRequest(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest = {
    import DescribeConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeConnectorRequest.ReadOnly =
    zio.aws.transfer.model.DescribeConnectorRequest.wrap(buildAwsValue())
}
object DescribeConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeConnectorRequest =
      zio.aws.transfer.model.DescribeConnectorRequest(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest
  ) extends zio.aws.transfer.model.DescribeConnectorRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeConnectorRequest
  ): zio.aws.transfer.model.DescribeConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
