package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeConnectorResponse(
    connector: zio.aws.transfer.model.DescribedConnector
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse = {
    import DescribeConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse
      .builder()
      .connector(connector.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly =
    zio.aws.transfer.model.DescribeConnectorResponse.wrap(buildAwsValue())
}
object DescribeConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeConnectorResponse =
      zio.aws.transfer.model.DescribeConnectorResponse(connector.asEditable)
    def connector: zio.aws.transfer.model.DescribedConnector.ReadOnly
    def getConnector: ZIO[
      Any,
      Nothing,
      zio.aws.transfer.model.DescribedConnector.ReadOnly
    ] = ZIO.succeed(connector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse
  ) extends zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly {
    override val connector: zio.aws.transfer.model.DescribedConnector.ReadOnly =
      zio.aws.transfer.model.DescribedConnector.wrap(impl.connector())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeConnectorResponse
  ): zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
