package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.WorkflowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExecutionResponse(
    workflowId: WorkflowId,
    execution: zio.aws.transfer.model.DescribedExecution
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse = {
    import DescribeExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .execution(execution.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly =
    zio.aws.transfer.model.DescribeExecutionResponse.wrap(buildAwsValue())
}
object DescribeExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeExecutionResponse =
      zio.aws.transfer.model
        .DescribeExecutionResponse(workflowId, execution.asEditable)
    def workflowId: WorkflowId
    def execution: zio.aws.transfer.model.DescribedExecution.ReadOnly
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getExecution: ZIO[
      Any,
      Nothing,
      zio.aws.transfer.model.DescribedExecution.ReadOnly
    ] = ZIO.succeed(execution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse
  ) extends zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
    override val execution: zio.aws.transfer.model.DescribedExecution.ReadOnly =
      zio.aws.transfer.model.DescribedExecution.wrap(impl.execution())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeExecutionResponse
  ): zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
