package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProfileResponse(
    profile: zio.aws.transfer.model.DescribedProfile
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeProfileResponse = {
    import DescribeProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeProfileResponse
      .builder()
      .profile(profile.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeProfileResponse.ReadOnly =
    zio.aws.transfer.model.DescribeProfileResponse.wrap(buildAwsValue())
}
object DescribeProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeProfileResponse =
      zio.aws.transfer.model.DescribeProfileResponse(profile.asEditable)
    def profile: zio.aws.transfer.model.DescribedProfile.ReadOnly
    def getProfile
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedProfile.ReadOnly] =
      ZIO.succeed(profile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeProfileResponse
  ) extends zio.aws.transfer.model.DescribeProfileResponse.ReadOnly {
    override val profile: zio.aws.transfer.model.DescribedProfile.ReadOnly =
      zio.aws.transfer.model.DescribedProfile.wrap(impl.profile())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeProfileResponse
  ): zio.aws.transfer.model.DescribeProfileResponse.ReadOnly = new Wrapper(impl)
}
