package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.WorkflowId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeWorkflowRequest(workflowId: WorkflowId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest = {
    import DescribeWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeWorkflowRequest.ReadOnly =
    zio.aws.transfer.model.DescribeWorkflowRequest.wrap(buildAwsValue())
}
object DescribeWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeWorkflowRequest =
      zio.aws.transfer.model.DescribeWorkflowRequest(workflowId)
    def workflowId: WorkflowId
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest
  ) extends zio.aws.transfer.model.DescribeWorkflowRequest.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeWorkflowRequest
  ): zio.aws.transfer.model.DescribeWorkflowRequest.ReadOnly = new Wrapper(impl)
}
