package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait DirectoryListingOptimization {
  def unwrap: software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization
}
object DirectoryListingOptimization {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization
  ): zio.aws.transfer.model.DirectoryListingOptimization = value match {
    case software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.DirectoryListingOptimization {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization =
      software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.transfer.model.DirectoryListingOptimization {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization =
      software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.ENABLED
  }
  case object DISABLED
      extends zio.aws.transfer.model.DirectoryListingOptimization {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization =
      software.amazon.awssdk.services.transfer.model.DirectoryListingOptimization.DISABLED
  }
}
