package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.transfer.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.EncryptionType
  ): zio.aws.transfer.model.EncryptionType = value match {
    case software.amazon.awssdk.services.transfer.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionType.PGP =>
      val r = PGP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionType =
      software.amazon.awssdk.services.transfer.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PGP extends zio.aws.transfer.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionType =
      software.amazon.awssdk.services.transfer.model.EncryptionType.PGP
  }
}
