package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{
  PrivateKeyType,
  CertificateChainType,
  CertificateBodyType,
  CertDate,
  Description
}
import scala.jdk.CollectionConverters._
final case class ImportCertificateRequest(
    usage: zio.aws.transfer.model.CertificateUsageType,
    certificate: CertificateBodyType,
    certificateChain: Optional[CertificateChainType] = Optional.Absent,
    privateKey: Optional[PrivateKeyType] = Optional.Absent,
    activeDate: Optional[CertDate] = Optional.Absent,
    inactiveDate: Optional[CertDate] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportCertificateRequest = {
    import ImportCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportCertificateRequest
      .builder()
      .usage(usage.unwrap)
      .certificate(CertificateBodyType.unwrap(certificate): java.lang.String)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChainType.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(
        privateKey.map(value => PrivateKeyType.unwrap(value): java.lang.String)
      )(_.privateKey)
      .optionallyWith(activeDate.map(value => CertDate.unwrap(value): Instant))(
        _.activeDate
      )
      .optionallyWith(
        inactiveDate.map(value => CertDate.unwrap(value): Instant)
      )(_.inactiveDate)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportCertificateRequest.ReadOnly =
    zio.aws.transfer.model.ImportCertificateRequest.wrap(buildAwsValue())
}
object ImportCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportCertificateRequest =
      zio.aws.transfer.model.ImportCertificateRequest(
        usage,
        certificate,
        certificateChain.map(value => value),
        privateKey.map(value => value),
        activeDate.map(value => value),
        inactiveDate.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def usage: zio.aws.transfer.model.CertificateUsageType
    def certificate: CertificateBodyType
    def certificateChain: Optional[CertificateChainType]
    def privateKey: Optional[PrivateKeyType]
    def activeDate: Optional[CertDate]
    def inactiveDate: Optional[CertDate]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getUsage
        : ZIO[Any, Nothing, zio.aws.transfer.model.CertificateUsageType] =
      ZIO.succeed(usage)
    def getCertificate: ZIO[Any, Nothing, CertificateBodyType] =
      ZIO.succeed(certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainType] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getPrivateKey: ZIO[Any, AwsError, PrivateKeyType] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getActiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("activeDate", activeDate)
    def getInactiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("inactiveDate", inactiveDate)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportCertificateRequest
  ) extends zio.aws.transfer.model.ImportCertificateRequest.ReadOnly {
    override val usage: zio.aws.transfer.model.CertificateUsageType =
      zio.aws.transfer.model.CertificateUsageType.wrap(impl.usage())
    override val certificate: CertificateBodyType =
      zio.aws.transfer.model.primitives.CertificateBodyType(impl.certificate())
    override val certificateChain: Optional[CertificateChainType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value =>
          zio.aws.transfer.model.primitives.CertificateChainType(value)
        )
    override val privateKey: Optional[PrivateKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => zio.aws.transfer.model.primitives.PrivateKeyType(value))
    override val activeDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val inactiveDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.inactiveDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportCertificateRequest
  ): zio.aws.transfer.model.ImportCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
