package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{HostKeyId, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportHostKeyResponse(
    serverId: ServerId,
    hostKeyId: HostKeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse = {
    import ImportHostKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .hostKeyId(HostKeyId.unwrap(hostKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly =
    zio.aws.transfer.model.ImportHostKeyResponse.wrap(buildAwsValue())
}
object ImportHostKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportHostKeyResponse =
      zio.aws.transfer.model.ImportHostKeyResponse(serverId, hostKeyId)
    def serverId: ServerId
    def hostKeyId: HostKeyId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getHostKeyId: ZIO[Any, Nothing, HostKeyId] = ZIO.succeed(hostKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse
  ) extends zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val hostKeyId: HostKeyId =
      zio.aws.transfer.model.primitives.HostKeyId(impl.hostKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportHostKeyResponse
  ): zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly = new Wrapper(impl)
}
