package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{WorkflowId, NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListExecutionsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowId: WorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListExecutionsRequest = {
    import ListExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListExecutionsRequest.ReadOnly =
    zio.aws.transfer.model.ListExecutionsRequest.wrap(buildAwsValue())
}
object ListExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListExecutionsRequest =
      zio.aws.transfer.model.ListExecutionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workflowId
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def workflowId: WorkflowId
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ) extends zio.aws.transfer.model.ListExecutionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsRequest
  ): zio.aws.transfer.model.ListExecutionsRequest.ReadOnly = new Wrapper(impl)
}
