package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{
  MaxResults,
  NextToken,
  TransferId,
  ConnectorId
}
import scala.jdk.CollectionConverters._
final case class ListFileTransferResultsRequest(
    connectorId: ConnectorId,
    transferId: TransferId,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest = {
    import ListFileTransferResultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .transferId(TransferId.unwrap(transferId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.transfer.model.ListFileTransferResultsRequest.ReadOnly =
    zio.aws.transfer.model.ListFileTransferResultsRequest.wrap(buildAwsValue())
}
object ListFileTransferResultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListFileTransferResultsRequest =
      zio.aws.transfer.model.ListFileTransferResultsRequest(
        connectorId,
        transferId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def connectorId: ConnectorId
    def transferId: TransferId
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
    def getTransferId: ZIO[Any, Nothing, TransferId] = ZIO.succeed(transferId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest
  ) extends zio.aws.transfer.model.ListFileTransferResultsRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
    override val transferId: TransferId =
      zio.aws.transfer.model.primitives.TransferId(impl.transferId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListFileTransferResultsRequest
  ): zio.aws.transfer.model.ListFileTransferResultsRequest.ReadOnly =
    new Wrapper(impl)
}
