package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProfilesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    profiles: Iterable[zio.aws.transfer.model.ListedProfile]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListProfilesResponse = {
    import ListProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListProfilesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .profiles(profiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListProfilesResponse.ReadOnly =
    zio.aws.transfer.model.ListProfilesResponse.wrap(buildAwsValue())
}
object ListProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListProfilesResponse =
      zio.aws.transfer.model.ListProfilesResponse(
        nextToken.map(value => value),
        profiles.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def profiles: List[zio.aws.transfer.model.ListedProfile.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProfiles: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedProfile.ReadOnly
    ]] = ZIO.succeed(profiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListProfilesResponse
  ) extends zio.aws.transfer.model.ListProfilesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val profiles: List[zio.aws.transfer.model.ListedProfile.ReadOnly] =
      impl
        .profiles()
        .asScala
        .map { item =>
          zio.aws.transfer.model.ListedProfile.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListProfilesResponse
  ): zio.aws.transfer.model.ListProfilesResponse.ReadOnly = new Wrapper(impl)
}
