package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkflowsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflows: Iterable[zio.aws.transfer.model.ListedWorkflow]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse = {
    import ListWorkflowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflows(workflows.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly =
    zio.aws.transfer.model.ListWorkflowsResponse.wrap(buildAwsValue())
}
object ListWorkflowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListWorkflowsResponse =
      zio.aws.transfer.model.ListWorkflowsResponse(
        nextToken.map(value => value),
        workflows.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def workflows: List[zio.aws.transfer.model.ListedWorkflow.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflows: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedWorkflow.ReadOnly
    ]] = ZIO.succeed(workflows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse
  ) extends zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val workflows
        : List[zio.aws.transfer.model.ListedWorkflow.ReadOnly] = impl
      .workflows()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedWorkflow.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListWorkflowsResponse
  ): zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly = new Wrapper(impl)
}
