package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{
  Arn,
  HomeDirectory,
  SshPublicKeyCount,
  Role,
  UserName
}
import scala.jdk.CollectionConverters._
final case class ListedUser(
    arn: Arn,
    homeDirectory: Optional[HomeDirectory] = Optional.Absent,
    homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType] =
      Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    sshPublicKeyCount: Optional[SshPublicKeyCount] = Optional.Absent,
    userName: Optional[UserName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedUser = {
    import ListedUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedUser
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .optionallyWith(
        sshPublicKeyCount.map(value => SshPublicKeyCount.unwrap(value): Integer)
      )(_.sshPublicKeyCount)
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedUser.ReadOnly =
    zio.aws.transfer.model.ListedUser.wrap(buildAwsValue())
}
object ListedUser {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedUser
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedUser =
      zio.aws.transfer.model.ListedUser(
        arn,
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        role.map(value => value),
        sshPublicKeyCount.map(value => value),
        userName.map(value => value)
      )
    def arn: Arn
    def homeDirectory: Optional[HomeDirectory]
    def homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType]
    def role: Optional[Role]
    def sshPublicKeyCount: Optional[SshPublicKeyCount]
    def userName: Optional[UserName]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getSshPublicKeyCount: ZIO[Any, AwsError, SshPublicKeyCount] =
      AwsError.unwrapOptionField("sshPublicKeyCount", sshPublicKeyCount)
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedUser
  ) extends zio.aws.transfer.model.ListedUser.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val homeDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Optional[zio.aws.transfer.model.HomeDirectoryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeDirectoryType())
        .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val sshPublicKeyCount: Optional[SshPublicKeyCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sshPublicKeyCount())
        .map(value =>
          zio.aws.transfer.model.primitives.SshPublicKeyCount(value)
        )
    override val userName: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.transfer.model.primitives.UserName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedUser
  ): zio.aws.transfer.model.ListedUser.ReadOnly = new Wrapper(impl)
}
