package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait MdnResponse {
  def unwrap: software.amazon.awssdk.services.transfer.model.MdnResponse
}
object MdnResponse {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.MdnResponse
  ): zio.aws.transfer.model.MdnResponse = value match {
    case software.amazon.awssdk.services.transfer.model.MdnResponse.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.MdnResponse.SYNC =>
      val r = SYNC
      r
    case software.amazon.awssdk.services.transfer.model.MdnResponse.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.MdnResponse {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnResponse =
      software.amazon.awssdk.services.transfer.model.MdnResponse.UNKNOWN_TO_SDK_VERSION
  }
  case object SYNC extends zio.aws.transfer.model.MdnResponse {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnResponse =
      software.amazon.awssdk.services.transfer.model.MdnResponse.SYNC
  }
  case object NONE extends zio.aws.transfer.model.MdnResponse {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnResponse =
      software.amazon.awssdk.services.transfer.model.MdnResponse.NONE
  }
}
