package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.transfer.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.Protocol
  ): zio.aws.transfer.model.Protocol = value match {
    case software.amazon.awssdk.services.transfer.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.Protocol.SFTP =>
      val r = SFTP
      r
    case software.amazon.awssdk.services.transfer.model.Protocol.FTP =>
      val r = FTP
      r
    case software.amazon.awssdk.services.transfer.model.Protocol.FTPS =>
      val r = FTPS
      r
    case software.amazon.awssdk.services.transfer.model.Protocol.AS2 =>
      val r = AS2
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.Protocol =
      software.amazon.awssdk.services.transfer.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object SFTP extends zio.aws.transfer.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.Protocol =
      software.amazon.awssdk.services.transfer.model.Protocol.SFTP
  }
  case object FTP extends zio.aws.transfer.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.Protocol =
      software.amazon.awssdk.services.transfer.model.Protocol.FTP
  }
  case object FTPS extends zio.aws.transfer.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.Protocol =
      software.amazon.awssdk.services.transfer.model.Protocol.FTPS
  }
  case object AS2 extends zio.aws.transfer.model.Protocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.Protocol =
      software.amazon.awssdk.services.transfer.model.Protocol.AS2
  }
}
