package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  CallbackToken,
  ExecutionId,
  WorkflowId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendWorkflowStepStateRequest(
    workflowId: WorkflowId,
    executionId: ExecutionId,
    token: CallbackToken,
    status: zio.aws.transfer.model.CustomStepStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest = {
    import SendWorkflowStepStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .executionId(ExecutionId.unwrap(executionId): java.lang.String)
      .token(CallbackToken.unwrap(token): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.SendWorkflowStepStateRequest.ReadOnly =
    zio.aws.transfer.model.SendWorkflowStepStateRequest.wrap(buildAwsValue())
}
object SendWorkflowStepStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.SendWorkflowStepStateRequest =
      zio.aws.transfer.model.SendWorkflowStepStateRequest(
        workflowId,
        executionId,
        token,
        status
      )
    def workflowId: WorkflowId
    def executionId: ExecutionId
    def token: CallbackToken
    def status: zio.aws.transfer.model.CustomStepStatus
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getExecutionId: ZIO[Any, Nothing, ExecutionId] =
      ZIO.succeed(executionId)
    def getToken: ZIO[Any, Nothing, CallbackToken] = ZIO.succeed(token)
    def getStatus: ZIO[Any, Nothing, zio.aws.transfer.model.CustomStepStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest
  ) extends zio.aws.transfer.model.SendWorkflowStepStateRequest.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
    override val executionId: ExecutionId =
      zio.aws.transfer.model.primitives.ExecutionId(impl.executionId())
    override val token: CallbackToken =
      zio.aws.transfer.model.primitives.CallbackToken(impl.token())
    override val status: zio.aws.transfer.model.CustomStepStatus =
      zio.aws.transfer.model.CustomStepStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.SendWorkflowStepStateRequest
  ): zio.aws.transfer.model.SendWorkflowStepStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
