package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{MaxItems, FilePath, ConnectorId}
import scala.jdk.CollectionConverters._
final case class StartDirectoryListingRequest(
    connectorId: ConnectorId,
    remoteDirectoryPath: FilePath,
    maxItems: Optional[MaxItems] = Optional.Absent,
    outputDirectoryPath: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StartDirectoryListingRequest = {
    import StartDirectoryListingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StartDirectoryListingRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .remoteDirectoryPath(
        FilePath.unwrap(remoteDirectoryPath): java.lang.String
      )
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .outputDirectoryPath(
        FilePath.unwrap(outputDirectoryPath): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.StartDirectoryListingRequest.ReadOnly =
    zio.aws.transfer.model.StartDirectoryListingRequest.wrap(buildAwsValue())
}
object StartDirectoryListingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StartDirectoryListingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StartDirectoryListingRequest =
      zio.aws.transfer.model.StartDirectoryListingRequest(
        connectorId,
        remoteDirectoryPath,
        maxItems.map(value => value),
        outputDirectoryPath
      )
    def connectorId: ConnectorId
    def remoteDirectoryPath: FilePath
    def maxItems: Optional[MaxItems]
    def outputDirectoryPath: FilePath
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
    def getRemoteDirectoryPath: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(remoteDirectoryPath)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getOutputDirectoryPath: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(outputDirectoryPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StartDirectoryListingRequest
  ) extends zio.aws.transfer.model.StartDirectoryListingRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
    override val remoteDirectoryPath: FilePath =
      zio.aws.transfer.model.primitives.FilePath(impl.remoteDirectoryPath())
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.transfer.model.primitives.MaxItems(value))
    override val outputDirectoryPath: FilePath =
      zio.aws.transfer.model.primitives.FilePath(impl.outputDirectoryPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StartDirectoryListingRequest
  ): zio.aws.transfer.model.StartDirectoryListingRequest.ReadOnly = new Wrapper(
    impl
  )
}
