package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TestConnectionRequest(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TestConnectionRequest = {
    import TestConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TestConnectionRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TestConnectionRequest.ReadOnly =
    zio.aws.transfer.model.TestConnectionRequest.wrap(buildAwsValue())
}
object TestConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TestConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TestConnectionRequest =
      zio.aws.transfer.model.TestConnectionRequest(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TestConnectionRequest
  ) extends zio.aws.transfer.model.TestConnectionRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TestConnectionRequest
  ): zio.aws.transfer.model.TestConnectionRequest.ReadOnly = new Wrapper(impl)
}
