package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateConnectorResponse(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse = {
    import UpdateConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly =
    zio.aws.transfer.model.UpdateConnectorResponse.wrap(buildAwsValue())
}
object UpdateConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateConnectorResponse =
      zio.aws.transfer.model.UpdateConnectorResponse(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse
  ) extends zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateConnectorResponse
  ): zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly = new Wrapper(impl)
}
