package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  HostKeyDescription,
  HostKeyId,
  ServerId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateHostKeyRequest(
    serverId: ServerId,
    hostKeyId: HostKeyId,
    description: HostKeyDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest = {
    import UpdateHostKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .hostKeyId(HostKeyId.unwrap(hostKeyId): java.lang.String)
      .description(HostKeyDescription.unwrap(description): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateHostKeyRequest.ReadOnly =
    zio.aws.transfer.model.UpdateHostKeyRequest.wrap(buildAwsValue())
}
object UpdateHostKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateHostKeyRequest =
      zio.aws.transfer.model
        .UpdateHostKeyRequest(serverId, hostKeyId, description)
    def serverId: ServerId
    def hostKeyId: HostKeyId
    def description: HostKeyDescription
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getHostKeyId: ZIO[Any, Nothing, HostKeyId] = ZIO.succeed(hostKeyId)
    def getDescription: ZIO[Any, Nothing, HostKeyDescription] =
      ZIO.succeed(description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest
  ) extends zio.aws.transfer.model.UpdateHostKeyRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val hostKeyId: HostKeyId =
      zio.aws.transfer.model.primitives.HostKeyId(impl.hostKeyId())
    override val description: HostKeyDescription =
      zio.aws.transfer.model.primitives.HostKeyDescription(impl.description())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateHostKeyRequest
  ): zio.aws.transfer.model.UpdateHostKeyRequest.ReadOnly = new Wrapper(impl)
}
