package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{CertificateId, ProfileId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProfileRequest(
    profileId: ProfileId,
    certificateIds: Optional[Iterable[CertificateId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateProfileRequest = {
    import UpdateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateProfileRequest
      .builder()
      .profileId(ProfileId.unwrap(profileId): java.lang.String)
      .optionallyWith(
        certificateIds.map(value =>
          value.map { item =>
            CertificateId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateIds)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateProfileRequest.ReadOnly =
    zio.aws.transfer.model.UpdateProfileRequest.wrap(buildAwsValue())
}
object UpdateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateProfileRequest =
      zio.aws.transfer.model
        .UpdateProfileRequest(profileId, certificateIds.map(value => value))
    def profileId: ProfileId
    def certificateIds: Optional[List[CertificateId]]
    def getProfileId: ZIO[Any, Nothing, ProfileId] = ZIO.succeed(profileId)
    def getCertificateIds: ZIO[Any, AwsError, List[CertificateId]] =
      AwsError.unwrapOptionField("certificateIds", certificateIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateProfileRequest
  ) extends zio.aws.transfer.model.UpdateProfileRequest.ReadOnly {
    override val profileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.profileId())
    override val certificateIds: Optional[List[CertificateId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.CertificateId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateProfileRequest
  ): zio.aws.transfer.model.UpdateProfileRequest.ReadOnly = new Wrapper(impl)
}
