package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SessionId, ServerId, UserName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserDetails(
    userName: UserName,
    serverId: ServerId,
    sessionId: Optional[SessionId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UserDetails = {
    import UserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UserDetails
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UserDetails.ReadOnly =
    zio.aws.transfer.model.UserDetails.wrap(buildAwsValue())
}
object UserDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UserDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UserDetails = zio.aws.transfer.model
      .UserDetails(userName, serverId, sessionId.map(value => value))
    def userName: UserName
    def serverId: ServerId
    def sessionId: Optional[SessionId]
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UserDetails
  ) extends zio.aws.transfer.model.UserDetails.ReadOnly {
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.transfer.model.primitives.SessionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UserDetails
  ): zio.aws.transfer.model.UserDetails.ReadOnly = new Wrapper(impl)
}
