package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkflowStep(
    `type`: Optional[zio.aws.transfer.model.WorkflowStepType] = Optional.Absent,
    copyStepDetails: Optional[zio.aws.transfer.model.CopyStepDetails] =
      Optional.Absent,
    customStepDetails: Optional[zio.aws.transfer.model.CustomStepDetails] =
      Optional.Absent,
    deleteStepDetails: Optional[zio.aws.transfer.model.DeleteStepDetails] =
      Optional.Absent,
    tagStepDetails: Optional[zio.aws.transfer.model.TagStepDetails] =
      Optional.Absent,
    decryptStepDetails: Optional[zio.aws.transfer.model.DecryptStepDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.WorkflowStep = {
    import WorkflowStep.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.WorkflowStep
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(copyStepDetails.map(value => value.buildAwsValue()))(
        _.copyStepDetails
      )
      .optionallyWith(customStepDetails.map(value => value.buildAwsValue()))(
        _.customStepDetails
      )
      .optionallyWith(deleteStepDetails.map(value => value.buildAwsValue()))(
        _.deleteStepDetails
      )
      .optionallyWith(tagStepDetails.map(value => value.buildAwsValue()))(
        _.tagStepDetails
      )
      .optionallyWith(decryptStepDetails.map(value => value.buildAwsValue()))(
        _.decryptStepDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.WorkflowStep.ReadOnly =
    zio.aws.transfer.model.WorkflowStep.wrap(buildAwsValue())
}
object WorkflowStep {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.WorkflowStep
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.WorkflowStep =
      zio.aws.transfer.model.WorkflowStep(
        `type`.map(value => value),
        copyStepDetails.map(value => value.asEditable),
        customStepDetails.map(value => value.asEditable),
        deleteStepDetails.map(value => value.asEditable),
        tagStepDetails.map(value => value.asEditable),
        decryptStepDetails.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.transfer.model.WorkflowStepType]
    def copyStepDetails
        : Optional[zio.aws.transfer.model.CopyStepDetails.ReadOnly]
    def customStepDetails
        : Optional[zio.aws.transfer.model.CustomStepDetails.ReadOnly]
    def deleteStepDetails
        : Optional[zio.aws.transfer.model.DeleteStepDetails.ReadOnly]
    def tagStepDetails: Optional[zio.aws.transfer.model.TagStepDetails.ReadOnly]
    def decryptStepDetails
        : Optional[zio.aws.transfer.model.DecryptStepDetails.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowStepType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCopyStepDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.CopyStepDetails.ReadOnly] =
      AwsError.unwrapOptionField("copyStepDetails", copyStepDetails)
    def getCustomStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.CustomStepDetails.ReadOnly
    ] = AwsError.unwrapOptionField("customStepDetails", customStepDetails)
    def getDeleteStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.DeleteStepDetails.ReadOnly
    ] = AwsError.unwrapOptionField("deleteStepDetails", deleteStepDetails)
    def getTagStepDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.TagStepDetails.ReadOnly] =
      AwsError.unwrapOptionField("tagStepDetails", tagStepDetails)
    def getDecryptStepDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.DecryptStepDetails.ReadOnly
    ] = AwsError.unwrapOptionField("decryptStepDetails", decryptStepDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowStep
  ) extends zio.aws.transfer.model.WorkflowStep.ReadOnly {
    override val `type`: Optional[zio.aws.transfer.model.WorkflowStepType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transfer.model.WorkflowStepType.wrap(value))
    override val copyStepDetails
        : Optional[zio.aws.transfer.model.CopyStepDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyStepDetails())
        .map(value => zio.aws.transfer.model.CopyStepDetails.wrap(value))
    override val customStepDetails
        : Optional[zio.aws.transfer.model.CustomStepDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customStepDetails())
        .map(value => zio.aws.transfer.model.CustomStepDetails.wrap(value))
    override val deleteStepDetails
        : Optional[zio.aws.transfer.model.DeleteStepDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteStepDetails())
        .map(value => zio.aws.transfer.model.DeleteStepDetails.wrap(value))
    override val tagStepDetails
        : Optional[zio.aws.transfer.model.TagStepDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagStepDetails())
        .map(value => zio.aws.transfer.model.TagStepDetails.wrap(value))
    override val decryptStepDetails
        : Optional[zio.aws.transfer.model.DecryptStepDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.decryptStepDetails())
        .map(value => zio.aws.transfer.model.DecryptStepDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowStep
  ): zio.aws.transfer.model.WorkflowStep.ReadOnly = new Wrapper(impl)
}
