package zio.aws.transfer
import zio.aws.transfer.model.ListedCertificate.ReadOnly
import software.amazon.awssdk.services.transfer.model.{
  ImportSshPublicKeyResponse,
  ListedConnector,
  ListHostKeysResponse,
  DeleteUserRequest,
  ListServersRequest,
  ListSecurityPoliciesResponse,
  UpdateProfileRequest,
  CreateWorkflowRequest,
  CreateAccessRequest,
  DescribeUserRequest,
  TestIdentityProviderResponse,
  ListedWorkflow,
  UpdateProfileResponse,
  ListFileTransferResultsResponse,
  TestConnectionRequest,
  StartFileTransferRequest,
  ListedAgreement,
  UpdateConnectorRequest,
  DescribeAgreementResponse,
  DescribeServerRequest,
  StopServerRequest,
  DeleteSshPublicKeyRequest,
  ListedAccess,
  UpdateAccessRequest,
  DeleteWorkflowResponse,
  ListSecurityPoliciesRequest,
  UpdateAgreementRequest,
  ListAgreementsResponse,
  ListHostKeysRequest,
  StartFileTransferResponse,
  ListUsersRequest,
  DescribeExecutionResponse,
  ListUsersResponse,
  UpdateConnectorResponse,
  ListWorkflowsRequest,
  DeleteAgreementResponse,
  UpdateAgreementResponse,
  ListConnectorsResponse,
  DescribeUserResponse,
  DescribeConnectorRequest,
  ListedExecution,
  ListedCertificate,
  ImportHostKeyResponse,
  UpdateServerResponse,
  ListedHostKey,
  DeleteCertificateResponse,
  CreateAgreementResponse,
  DeleteProfileResponse,
  StartDirectoryListingResponse,
  DescribeAgreementRequest,
  StartServerResponse,
  ListTagsForResourceRequest,
  Tag,
  DescribeProfileResponse,
  CreateWorkflowResponse,
  DescribeServerResponse,
  ImportCertificateResponse,
  DescribeHostKeyRequest,
  CreateProfileRequest,
  DeleteHostKeyResponse,
  ListProfilesRequest,
  ListTagsForResourceResponse,
  DeleteServerResponse,
  DescribeAccessResponse,
  ImportHostKeyRequest,
  UpdateCertificateResponse,
  UntagResourceResponse,
  DeleteProfileRequest,
  DeleteServerRequest,
  ListAccessesResponse,
  ListWorkflowsResponse,
  DeleteAgreementRequest,
  DeleteHostKeyRequest,
  CreateUserRequest,
  DescribeWorkflowRequest,
  ListCertificatesResponse,
  ListedServer,
  ListExecutionsRequest,
  DeleteSshPublicKeyResponse,
  CreateUserResponse,
  DescribeProfileRequest,
  DeleteAccessRequest,
  UpdateHostKeyRequest,
  ConnectorFileTransferResult,
  DeleteConnectorRequest,
  UpdateServerRequest,
  UpdateCertificateRequest,
  DescribeSecurityPolicyResponse,
  ListConnectorsRequest,
  SendWorkflowStepStateRequest,
  DescribeWorkflowResponse,
  CreateConnectorResponse,
  ListServersResponse,
  ListAccessesRequest,
  ListExecutionsResponse,
  DescribeAccessRequest,
  CreateAccessResponse,
  UntagResourceRequest,
  ListCertificatesRequest,
  UpdateAccessResponse,
  DeleteUserResponse,
  UpdateHostKeyResponse,
  StopServerResponse,
  DescribeSecurityPolicyRequest,
  ImportSshPublicKeyRequest,
  CreateAgreementRequest,
  ListedProfile,
  UpdateUserRequest,
  CreateServerRequest,
  TestConnectionResponse,
  CreateProfileResponse,
  StartDirectoryListingRequest,
  ImportCertificateRequest,
  DescribeCertificateResponse,
  DeleteConnectorResponse,
  DeleteAccessResponse,
  DescribeConnectorResponse,
  ListAgreementsRequest,
  UpdateUserResponse,
  TagResourceResponse,
  DeleteWorkflowRequest,
  ListedUser,
  ListFileTransferResultsRequest,
  CreateConnectorRequest,
  DescribeHostKeyResponse,
  DescribeExecutionRequest,
  DescribeCertificateRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  ListProfilesResponse,
  StartServerRequest,
  CreateServerResponse,
  SendWorkflowStepStateResponse,
  TestIdentityProviderRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.transfer.{
  TransferAsyncClientBuilder,
  TransferAsyncClient
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import zio.aws.transfer.model.primitives.SecurityPolicyName
import scala.jdk.CollectionConverters._
trait Transfer extends AspectSupport[Transfer] {
  val api: TransferAsyncClient
  def deleteHostKey(
      request: zio.aws.transfer.model.DeleteHostKeyRequest
  ): IO[AwsError, Unit]
  def updateServer(
      request: zio.aws.transfer.model.UpdateServerRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateServerResponse.ReadOnly]
  def updateConnector(
      request: zio.aws.transfer.model.UpdateConnectorRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly]
  def listUsers(
      request: zio.aws.transfer.model.ListUsersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly,
    zio.aws.transfer.model.ListedUser.ReadOnly
  ]]
  def listUsersPaginated(
      request: zio.aws.transfer.model.ListUsersRequest
  ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly]
  def updateUser(
      request: zio.aws.transfer.model.UpdateUserRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateUserResponse.ReadOnly]
  def deleteConnector(
      request: zio.aws.transfer.model.DeleteConnectorRequest
  ): IO[AwsError, Unit]
  def deleteServer(
      request: zio.aws.transfer.model.DeleteServerRequest
  ): IO[AwsError, Unit]
  def describeWorkflow(
      request: zio.aws.transfer.model.DescribeWorkflowRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly]
  def describeProfile(
      request: zio.aws.transfer.model.DescribeProfileRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeProfileResponse.ReadOnly]
  def createConnector(
      request: zio.aws.transfer.model.CreateConnectorRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateConnectorResponse.ReadOnly]
  def describeServer(
      request: zio.aws.transfer.model.DescribeServerRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeServerResponse.ReadOnly]
  def deleteAgreement(
      request: zio.aws.transfer.model.DeleteAgreementRequest
  ): IO[AwsError, Unit]
  def listSecurityPolicies(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZStream[Any, AwsError, SecurityPolicyName]
  def listSecurityPoliciesPaginated(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly]
  def startFileTransfer(
      request: zio.aws.transfer.model.StartFileTransferRequest
  ): IO[AwsError, zio.aws.transfer.model.StartFileTransferResponse.ReadOnly]
  def createAccess(
      request: zio.aws.transfer.model.CreateAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateAccessResponse.ReadOnly]
  def describeConnector(
      request: zio.aws.transfer.model.DescribeConnectorRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly]
  def startServer(
      request: zio.aws.transfer.model.StartServerRequest
  ): IO[AwsError, Unit]
  def importSshPublicKey(
      request: zio.aws.transfer.model.ImportSshPublicKeyRequest
  ): IO[AwsError, zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly]
  def describeExecution(
      request: zio.aws.transfer.model.DescribeExecutionRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly]
  def updateAgreement(
      request: zio.aws.transfer.model.UpdateAgreementRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly]
  def createUser(
      request: zio.aws.transfer.model.CreateUserRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateUserResponse.ReadOnly]
  def updateHostKey(
      request: zio.aws.transfer.model.UpdateHostKeyRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateHostKeyResponse.ReadOnly]
  def deleteCertificate(
      request: zio.aws.transfer.model.DeleteCertificateRequest
  ): IO[AwsError, Unit]
  def stopServer(
      request: zio.aws.transfer.model.StopServerRequest
  ): IO[AwsError, Unit]
  def testConnection(
      request: zio.aws.transfer.model.TestConnectionRequest
  ): IO[AwsError, zio.aws.transfer.model.TestConnectionResponse.ReadOnly]
  def createAgreement(
      request: zio.aws.transfer.model.CreateAgreementRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateAgreementResponse.ReadOnly]
  def listAccesses(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
    zio.aws.transfer.model.ListedAccess.ReadOnly
  ]]
  def listAccessesPaginated(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListAccessesResponse.ReadOnly]
  def describeAccess(
      request: zio.aws.transfer.model.DescribeAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeAccessResponse.ReadOnly]
  def deleteProfile(
      request: zio.aws.transfer.model.DeleteProfileRequest
  ): IO[AwsError, Unit]
  def sendWorkflowStepState(
      request: zio.aws.transfer.model.SendWorkflowStepStateRequest
  ): IO[AwsError, zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly]
  def startDirectoryListing(
      request: zio.aws.transfer.model.StartDirectoryListingRequest
  ): IO[AwsError, zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly]
  def deleteAccess(
      request: zio.aws.transfer.model.DeleteAccessRequest
  ): IO[AwsError, Unit]
  def untagResource(
      request: zio.aws.transfer.model.UntagResourceRequest
  ): IO[AwsError, Unit]
  def updateCertificate(
      request: zio.aws.transfer.model.UpdateCertificateRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly]
  def listProfiles(
      request: zio.aws.transfer.model.ListProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedProfile.ReadOnly]
  def listProfilesPaginated(
      request: zio.aws.transfer.model.ListProfilesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListProfilesResponse.ReadOnly]
  def listFileTransferResults(
      request: zio.aws.transfer.model.ListFileTransferResultsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
  ]
  def listFileTransferResultsPaginated(
      request: zio.aws.transfer.model.ListFileTransferResultsRequest
  ): IO[
    AwsError,
    zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly
  ]
  def listExecutions(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
    zio.aws.transfer.model.ListedExecution.ReadOnly
  ]]
  def listExecutionsPaginated(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListExecutionsResponse.ReadOnly]
  def listHostKeys(
      request: zio.aws.transfer.model.ListHostKeysRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListHostKeysResponse.ReadOnly,
    zio.aws.transfer.model.ListedHostKey.ReadOnly
  ]]
  def listHostKeysPaginated(
      request: zio.aws.transfer.model.ListHostKeysRequest
  ): IO[AwsError, zio.aws.transfer.model.ListHostKeysResponse.ReadOnly]
  def describeUser(
      request: zio.aws.transfer.model.DescribeUserRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeUserResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
    zio.aws.transfer.model.Tag.ReadOnly
  ]]
  def listTagsForResourcePaginated(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly]
  def createServer(
      request: zio.aws.transfer.model.CreateServerRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateServerResponse.ReadOnly]
  def tagResource(
      request: zio.aws.transfer.model.TagResourceRequest
  ): IO[AwsError, Unit]
  def testIdentityProvider(
      request: zio.aws.transfer.model.TestIdentityProviderRequest
  ): IO[AwsError, zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly]
  def createProfile(
      request: zio.aws.transfer.model.CreateProfileRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateProfileResponse.ReadOnly]
  def updateAccess(
      request: zio.aws.transfer.model.UpdateAccessRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateAccessResponse.ReadOnly]
  def describeHostKey(
      request: zio.aws.transfer.model.DescribeHostKeyRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly]
  def listWorkflows(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedWorkflow.ReadOnly]
  def listWorkflowsPaginated(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly]
  def deleteUser(
      request: zio.aws.transfer.model.DeleteUserRequest
  ): IO[AwsError, Unit]
  def describeAgreement(
      request: zio.aws.transfer.model.DescribeAgreementRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly]
  def describeSecurityPolicy(
      request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
  ): IO[
    AwsError,
    zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
  ]
  def deleteSshPublicKey(
      request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
  ): IO[AwsError, Unit]
  def importHostKey(
      request: zio.aws.transfer.model.ImportHostKeyRequest
  ): IO[AwsError, zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly]
  def updateProfile(
      request: zio.aws.transfer.model.UpdateProfileRequest
  ): IO[AwsError, zio.aws.transfer.model.UpdateProfileResponse.ReadOnly]
  def describeCertificate(
      request: zio.aws.transfer.model.DescribeCertificateRequest
  ): IO[AwsError, zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly]
  def listAgreements(
      request: zio.aws.transfer.model.ListAgreementsRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedAgreement.ReadOnly]
  def listAgreementsPaginated(
      request: zio.aws.transfer.model.ListAgreementsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListAgreementsResponse.ReadOnly]
  def listCertificates(
      request: zio.aws.transfer.model.ListCertificatesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listCertificatesPaginated(
      request: zio.aws.transfer.model.ListCertificatesRequest
  ): IO[AwsError, zio.aws.transfer.model.ListCertificatesResponse.ReadOnly]
  def deleteWorkflow(
      request: zio.aws.transfer.model.DeleteWorkflowRequest
  ): IO[AwsError, Unit]
  def importCertificate(
      request: zio.aws.transfer.model.ImportCertificateRequest
  ): IO[AwsError, zio.aws.transfer.model.ImportCertificateResponse.ReadOnly]
  def createWorkflow(
      request: zio.aws.transfer.model.CreateWorkflowRequest
  ): IO[AwsError, zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly]
  def listConnectors(
      request: zio.aws.transfer.model.ListConnectorsRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedConnector.ReadOnly]
  def listConnectorsPaginated(
      request: zio.aws.transfer.model.ListConnectorsRequest
  ): IO[AwsError, zio.aws.transfer.model.ListConnectorsResponse.ReadOnly]
  def listServers(
      request: zio.aws.transfer.model.ListServersRequest
  ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedServer.ReadOnly]
  def listServersPaginated(
      request: zio.aws.transfer.model.ListServersRequest
  ): IO[AwsError, zio.aws.transfer.model.ListServersResponse.ReadOnly]
}
object Transfer {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Transfer] = customized(
    identity
  )
  def customized(
      customization: TransferAsyncClientBuilder => TransferAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Transfer] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: TransferAsyncClientBuilder => TransferAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Transfer] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = TransferAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[TransferAsyncClient, TransferAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[TransferAsyncClient, TransferAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new TransferImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TransferImpl[R](
      override val api: TransferAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Transfer
      with AwsServiceBase[R] {
    override val serviceName: String = "Transfer"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TransferImpl[R1] = new TransferImpl(api, newAspect, r)
    def deleteHostKey(
        request: zio.aws.transfer.model.DeleteHostKeyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteHostKeyRequest, DeleteHostKeyResponse](
        "deleteHostKey",
        api.deleteHostKey
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateServer(
        request: zio.aws.transfer.model.UpdateServerRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateServerResponse.ReadOnly] =
      asyncRequestResponse[UpdateServerRequest, UpdateServerResponse](
        "updateServer",
        api.updateServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateServerResponse.wrap)
        .provideEnvironment(r)
    def updateConnector(
        request: zio.aws.transfer.model.UpdateConnectorRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly] =
      asyncRequestResponse[UpdateConnectorRequest, UpdateConnectorResponse](
        "updateConnector",
        api.updateConnector
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateConnectorResponse.wrap)
        .provideEnvironment(r)
    def listUsers(
        request: zio.aws.transfer.model.ListUsersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListUsersResponse.ReadOnly,
      zio.aws.transfer.model.ListedUser.ReadOnly
    ]] = asyncPaginatedRequest[ListUsersRequest, ListUsersResponse, ListedUser](
      "listUsers",
      api.listUsers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.users().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListUsersResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedUser.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listUsersPaginated(
        request: zio.aws.transfer.model.ListUsersRequest
    ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[ListUsersRequest, ListUsersResponse](
        "listUsers",
        api.listUsers
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: zio.aws.transfer.model.UpdateUserRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def deleteConnector(
        request: zio.aws.transfer.model.DeleteConnectorRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteConnectorRequest, DeleteConnectorResponse](
        "deleteConnector",
        api.deleteConnector
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteServer(
        request: zio.aws.transfer.model.DeleteServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteServerRequest, DeleteServerResponse](
        "deleteServer",
        api.deleteServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeWorkflow(
        request: zio.aws.transfer.model.DescribeWorkflowRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly] =
      asyncRequestResponse[DescribeWorkflowRequest, DescribeWorkflowResponse](
        "describeWorkflow",
        api.describeWorkflow
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeWorkflowResponse.wrap)
        .provideEnvironment(r)
    def describeProfile(
        request: zio.aws.transfer.model.DescribeProfileRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeProfileResponse.ReadOnly] =
      asyncRequestResponse[DescribeProfileRequest, DescribeProfileResponse](
        "describeProfile",
        api.describeProfile
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeProfileResponse.wrap)
        .provideEnvironment(r)
    def createConnector(
        request: zio.aws.transfer.model.CreateConnectorRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateConnectorResponse.ReadOnly] =
      asyncRequestResponse[CreateConnectorRequest, CreateConnectorResponse](
        "createConnector",
        api.createConnector
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateConnectorResponse.wrap)
        .provideEnvironment(r)
    def describeServer(
        request: zio.aws.transfer.model.DescribeServerRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeServerResponse.ReadOnly] =
      asyncRequestResponse[DescribeServerRequest, DescribeServerResponse](
        "describeServer",
        api.describeServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeServerResponse.wrap)
        .provideEnvironment(r)
    def deleteAgreement(
        request: zio.aws.transfer.model.DeleteAgreementRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAgreementRequest, DeleteAgreementResponse](
        "deleteAgreement",
        api.deleteAgreement
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listSecurityPolicies(
        request: zio.aws.transfer.model.ListSecurityPoliciesRequest
    ): ZStream[Any, AwsError, SecurityPolicyName] = asyncSimplePaginatedRequest[
      ListSecurityPoliciesRequest,
      ListSecurityPoliciesResponse,
      java.lang.String
    ](
      "listSecurityPolicies",
      api.listSecurityPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityPolicyNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.transfer.model.primitives.SecurityPolicyName(item))
      .provideEnvironment(r)
    def listSecurityPoliciesPaginated(
        request: zio.aws.transfer.model.ListSecurityPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSecurityPoliciesRequest,
      ListSecurityPoliciesResponse
    ]("listSecurityPolicies", api.listSecurityPolicies)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ListSecurityPoliciesResponse.wrap)
      .provideEnvironment(r)
    def startFileTransfer(
        request: zio.aws.transfer.model.StartFileTransferRequest
    ): IO[AwsError, zio.aws.transfer.model.StartFileTransferResponse.ReadOnly] =
      asyncRequestResponse[StartFileTransferRequest, StartFileTransferResponse](
        "startFileTransfer",
        api.startFileTransfer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.StartFileTransferResponse.wrap)
        .provideEnvironment(r)
    def createAccess(
        request: zio.aws.transfer.model.CreateAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateAccessResponse.ReadOnly] =
      asyncRequestResponse[CreateAccessRequest, CreateAccessResponse](
        "createAccess",
        api.createAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateAccessResponse.wrap)
        .provideEnvironment(r)
    def describeConnector(
        request: zio.aws.transfer.model.DescribeConnectorRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly] =
      asyncRequestResponse[DescribeConnectorRequest, DescribeConnectorResponse](
        "describeConnector",
        api.describeConnector
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeConnectorResponse.wrap)
        .provideEnvironment(r)
    def startServer(
        request: zio.aws.transfer.model.StartServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[StartServerRequest, StartServerResponse](
        "startServer",
        api.startServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def importSshPublicKey(
        request: zio.aws.transfer.model.ImportSshPublicKeyRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportSshPublicKeyRequest,
      ImportSshPublicKeyResponse
    ]("importSshPublicKey", api.importSshPublicKey)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ImportSshPublicKeyResponse.wrap)
      .provideEnvironment(r)
    def describeExecution(
        request: zio.aws.transfer.model.DescribeExecutionRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly] =
      asyncRequestResponse[DescribeExecutionRequest, DescribeExecutionResponse](
        "describeExecution",
        api.describeExecution
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeExecutionResponse.wrap)
        .provideEnvironment(r)
    def updateAgreement(
        request: zio.aws.transfer.model.UpdateAgreementRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly] =
      asyncRequestResponse[UpdateAgreementRequest, UpdateAgreementResponse](
        "updateAgreement",
        api.updateAgreement
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateAgreementResponse.wrap)
        .provideEnvironment(r)
    def createUser(
        request: zio.aws.transfer.model.CreateUserRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def updateHostKey(
        request: zio.aws.transfer.model.UpdateHostKeyRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateHostKeyResponse.ReadOnly] =
      asyncRequestResponse[UpdateHostKeyRequest, UpdateHostKeyResponse](
        "updateHostKey",
        api.updateHostKey
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateHostKeyResponse.wrap)
        .provideEnvironment(r)
    def deleteCertificate(
        request: zio.aws.transfer.model.DeleteCertificateRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteCertificateRequest, DeleteCertificateResponse](
        "deleteCertificate",
        api.deleteCertificate
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def stopServer(
        request: zio.aws.transfer.model.StopServerRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[StopServerRequest, StopServerResponse](
        "stopServer",
        api.stopServer
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def testConnection(
        request: zio.aws.transfer.model.TestConnectionRequest
    ): IO[AwsError, zio.aws.transfer.model.TestConnectionResponse.ReadOnly] =
      asyncRequestResponse[TestConnectionRequest, TestConnectionResponse](
        "testConnection",
        api.testConnection
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.TestConnectionResponse.wrap)
        .provideEnvironment(r)
    def createAgreement(
        request: zio.aws.transfer.model.CreateAgreementRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateAgreementResponse.ReadOnly] =
      asyncRequestResponse[CreateAgreementRequest, CreateAgreementResponse](
        "createAgreement",
        api.createAgreement
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateAgreementResponse.wrap)
        .provideEnvironment(r)
    def listAccesses(
        request: zio.aws.transfer.model.ListAccessesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
      zio.aws.transfer.model.ListedAccess.ReadOnly
    ]] = asyncPaginatedRequest[
      ListAccessesRequest,
      ListAccessesResponse,
      ListedAccess
    ](
      "listAccesses",
      api.listAccesses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accesses().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListAccessesResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedAccess.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listAccessesPaginated(
        request: zio.aws.transfer.model.ListAccessesRequest
    ): IO[AwsError, zio.aws.transfer.model.ListAccessesResponse.ReadOnly] =
      asyncRequestResponse[ListAccessesRequest, ListAccessesResponse](
        "listAccesses",
        api.listAccesses
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListAccessesResponse.wrap)
        .provideEnvironment(r)
    def describeAccess(
        request: zio.aws.transfer.model.DescribeAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeAccessResponse.ReadOnly] =
      asyncRequestResponse[DescribeAccessRequest, DescribeAccessResponse](
        "describeAccess",
        api.describeAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeAccessResponse.wrap)
        .provideEnvironment(r)
    def deleteProfile(
        request: zio.aws.transfer.model.DeleteProfileRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteProfileRequest, DeleteProfileResponse](
        "deleteProfile",
        api.deleteProfile
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def sendWorkflowStepState(
        request: zio.aws.transfer.model.SendWorkflowStepStateRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
    ] = asyncRequestResponse[
      SendWorkflowStepStateRequest,
      SendWorkflowStepStateResponse
    ]("sendWorkflowStepState", api.sendWorkflowStepState)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.SendWorkflowStepStateResponse.wrap)
      .provideEnvironment(r)
    def startDirectoryListing(
        request: zio.aws.transfer.model.StartDirectoryListingRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDirectoryListingRequest,
      StartDirectoryListingResponse
    ]("startDirectoryListing", api.startDirectoryListing)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.StartDirectoryListingResponse.wrap)
      .provideEnvironment(r)
    def deleteAccess(
        request: zio.aws.transfer.model.DeleteAccessRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteAccessRequest, DeleteAccessResponse](
        "deleteAccess",
        api.deleteAccess
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def untagResource(
        request: zio.aws.transfer.model.UntagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateCertificate(
        request: zio.aws.transfer.model.UpdateCertificateRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly] =
      asyncRequestResponse[UpdateCertificateRequest, UpdateCertificateResponse](
        "updateCertificate",
        api.updateCertificate
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateCertificateResponse.wrap)
        .provideEnvironment(r)
    def listProfiles(
        request: zio.aws.transfer.model.ListProfilesRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedProfile.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListProfilesRequest,
        ListProfilesResponse,
        ListedProfile
      ](
        "listProfiles",
        api.listProfiles,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.profiles().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedProfile.wrap(item))
        .provideEnvironment(r)
    def listProfilesPaginated(
        request: zio.aws.transfer.model.ListProfilesRequest
    ): IO[AwsError, zio.aws.transfer.model.ListProfilesResponse.ReadOnly] =
      asyncRequestResponse[ListProfilesRequest, ListProfilesResponse](
        "listProfiles",
        api.listProfiles
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListProfilesResponse.wrap)
        .provideEnvironment(r)
    def listFileTransferResults(
        request: zio.aws.transfer.model.ListFileTransferResultsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListFileTransferResultsRequest,
      ListFileTransferResultsResponse,
      ConnectorFileTransferResult
    ](
      "listFileTransferResults",
      api.listFileTransferResults,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fileTransferResults().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.transfer.model.ConnectorFileTransferResult.wrap(item)
      )
      .provideEnvironment(r)
    def listFileTransferResultsPaginated(
        request: zio.aws.transfer.model.ListFileTransferResultsRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFileTransferResultsRequest,
      ListFileTransferResultsResponse
    ]("listFileTransferResults", api.listFileTransferResults)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.ListFileTransferResultsResponse.wrap)
      .provideEnvironment(r)
    def listExecutions(
        request: zio.aws.transfer.model.ListExecutionsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
      zio.aws.transfer.model.ListedExecution.ReadOnly
    ]] = asyncPaginatedRequest[
      ListExecutionsRequest,
      ListExecutionsResponse,
      ListedExecution
    ](
      "listExecutions",
      api.listExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.executions().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListExecutionsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedExecution.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listExecutionsPaginated(
        request: zio.aws.transfer.model.ListExecutionsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListExecutionsResponse.ReadOnly] =
      asyncRequestResponse[ListExecutionsRequest, ListExecutionsResponse](
        "listExecutions",
        api.listExecutions
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListExecutionsResponse.wrap)
        .provideEnvironment(r)
    def listHostKeys(
        request: zio.aws.transfer.model.ListHostKeysRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListHostKeysResponse.ReadOnly,
      zio.aws.transfer.model.ListedHostKey.ReadOnly
    ]] = asyncPaginatedRequest[
      ListHostKeysRequest,
      ListHostKeysResponse,
      ListedHostKey
    ](
      "listHostKeys",
      api.listHostKeys,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hostKeys().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListHostKeysResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.transfer.model.ListedHostKey.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listHostKeysPaginated(
        request: zio.aws.transfer.model.ListHostKeysRequest
    ): IO[AwsError, zio.aws.transfer.model.ListHostKeysResponse.ReadOnly] =
      asyncRequestResponse[ListHostKeysRequest, ListHostKeysResponse](
        "listHostKeys",
        api.listHostKeys
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListHostKeysResponse.wrap)
        .provideEnvironment(r)
    def describeUser(
        request: zio.aws.transfer.model.DescribeUserRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeUserResponse.ReadOnly] =
      asyncRequestResponse[DescribeUserRequest, DescribeUserResponse](
        "describeUser",
        api.describeUser
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeUserResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.transfer.model.ListTagsForResourceRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
      zio.aws.transfer.model.Tag.ReadOnly
    ]] = asyncPaginatedRequest[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      Tag
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.transfer.model.ListTagsForResourceResponse.wrap)
          .mapOutput(_.map(item => zio.aws.transfer.model.Tag.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.transfer.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.transfer.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createServer(
        request: zio.aws.transfer.model.CreateServerRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateServerResponse.ReadOnly] =
      asyncRequestResponse[CreateServerRequest, CreateServerResponse](
        "createServer",
        api.createServer
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateServerResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.transfer.model.TagResourceRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def testIdentityProvider(
        request: zio.aws.transfer.model.TestIdentityProviderRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
    ] = asyncRequestResponse[
      TestIdentityProviderRequest,
      TestIdentityProviderResponse
    ]("testIdentityProvider", api.testIdentityProvider)(request.buildAwsValue())
      .map(zio.aws.transfer.model.TestIdentityProviderResponse.wrap)
      .provideEnvironment(r)
    def createProfile(
        request: zio.aws.transfer.model.CreateProfileRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateProfileResponse.ReadOnly] =
      asyncRequestResponse[CreateProfileRequest, CreateProfileResponse](
        "createProfile",
        api.createProfile
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateProfileResponse.wrap)
        .provideEnvironment(r)
    def updateAccess(
        request: zio.aws.transfer.model.UpdateAccessRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateAccessResponse.ReadOnly] =
      asyncRequestResponse[UpdateAccessRequest, UpdateAccessResponse](
        "updateAccess",
        api.updateAccess
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateAccessResponse.wrap)
        .provideEnvironment(r)
    def describeHostKey(
        request: zio.aws.transfer.model.DescribeHostKeyRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly] =
      asyncRequestResponse[DescribeHostKeyRequest, DescribeHostKeyResponse](
        "describeHostKey",
        api.describeHostKey
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeHostKeyResponse.wrap)
        .provideEnvironment(r)
    def listWorkflows(
        request: zio.aws.transfer.model.ListWorkflowsRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedWorkflow.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListWorkflowsRequest,
        ListWorkflowsResponse,
        ListedWorkflow
      ](
        "listWorkflows",
        api.listWorkflows,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.workflows().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedWorkflow.wrap(item))
        .provideEnvironment(r)
    def listWorkflowsPaginated(
        request: zio.aws.transfer.model.ListWorkflowsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly] =
      asyncRequestResponse[ListWorkflowsRequest, ListWorkflowsResponse](
        "listWorkflows",
        api.listWorkflows
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListWorkflowsResponse.wrap)
        .provideEnvironment(r)
    def deleteUser(
        request: zio.aws.transfer.model.DeleteUserRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeAgreement(
        request: zio.aws.transfer.model.DescribeAgreementRequest
    ): IO[AwsError, zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly] =
      asyncRequestResponse[DescribeAgreementRequest, DescribeAgreementResponse](
        "describeAgreement",
        api.describeAgreement
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.DescribeAgreementResponse.wrap)
        .provideEnvironment(r)
    def describeSecurityPolicy(
        request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSecurityPolicyRequest,
      DescribeSecurityPolicyResponse
    ]("describeSecurityPolicy", api.describeSecurityPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.transfer.model.DescribeSecurityPolicyResponse.wrap)
      .provideEnvironment(r)
    def deleteSshPublicKey(
        request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSshPublicKeyRequest,
      DeleteSshPublicKeyResponse
    ]("deleteSshPublicKey", api.deleteSshPublicKey)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def importHostKey(
        request: zio.aws.transfer.model.ImportHostKeyRequest
    ): IO[AwsError, zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly] =
      asyncRequestResponse[ImportHostKeyRequest, ImportHostKeyResponse](
        "importHostKey",
        api.importHostKey
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ImportHostKeyResponse.wrap)
        .provideEnvironment(r)
    def updateProfile(
        request: zio.aws.transfer.model.UpdateProfileRequest
    ): IO[AwsError, zio.aws.transfer.model.UpdateProfileResponse.ReadOnly] =
      asyncRequestResponse[UpdateProfileRequest, UpdateProfileResponse](
        "updateProfile",
        api.updateProfile
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.UpdateProfileResponse.wrap)
        .provideEnvironment(r)
    def describeCertificate(
        request: zio.aws.transfer.model.DescribeCertificateRequest
    ): IO[
      AwsError,
      zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCertificateRequest,
      DescribeCertificateResponse
    ]("describeCertificate", api.describeCertificate)(request.buildAwsValue())
      .map(zio.aws.transfer.model.DescribeCertificateResponse.wrap)
      .provideEnvironment(r)
    def listAgreements(
        request: zio.aws.transfer.model.ListAgreementsRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedAgreement.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAgreementsRequest,
        ListAgreementsResponse,
        ListedAgreement
      ](
        "listAgreements",
        api.listAgreements,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.agreements().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedAgreement.wrap(item))
        .provideEnvironment(r)
    def listAgreementsPaginated(
        request: zio.aws.transfer.model.ListAgreementsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListAgreementsResponse.ReadOnly] =
      asyncRequestResponse[ListAgreementsRequest, ListAgreementsResponse](
        "listAgreements",
        api.listAgreements
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListAgreementsResponse.wrap)
        .provideEnvironment(r)
    def listCertificates(
        request: zio.aws.transfer.model.ListCertificatesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      ListCertificatesRequest,
      ListCertificatesResponse,
      ListedCertificate
    ](
      "listCertificates",
      api.listCertificates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.certificates().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.transfer.model.ListedCertificate.wrap(item))
      .provideEnvironment(r)
    def listCertificatesPaginated(
        request: zio.aws.transfer.model.ListCertificatesRequest
    ): IO[AwsError, zio.aws.transfer.model.ListCertificatesResponse.ReadOnly] =
      asyncRequestResponse[ListCertificatesRequest, ListCertificatesResponse](
        "listCertificates",
        api.listCertificates
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListCertificatesResponse.wrap)
        .provideEnvironment(r)
    def deleteWorkflow(
        request: zio.aws.transfer.model.DeleteWorkflowRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteWorkflowRequest, DeleteWorkflowResponse](
        "deleteWorkflow",
        api.deleteWorkflow
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def importCertificate(
        request: zio.aws.transfer.model.ImportCertificateRequest
    ): IO[AwsError, zio.aws.transfer.model.ImportCertificateResponse.ReadOnly] =
      asyncRequestResponse[ImportCertificateRequest, ImportCertificateResponse](
        "importCertificate",
        api.importCertificate
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ImportCertificateResponse.wrap)
        .provideEnvironment(r)
    def createWorkflow(
        request: zio.aws.transfer.model.CreateWorkflowRequest
    ): IO[AwsError, zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly] =
      asyncRequestResponse[CreateWorkflowRequest, CreateWorkflowResponse](
        "createWorkflow",
        api.createWorkflow
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.CreateWorkflowResponse.wrap)
        .provideEnvironment(r)
    def listConnectors(
        request: zio.aws.transfer.model.ListConnectorsRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedConnector.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListConnectorsRequest,
        ListConnectorsResponse,
        ListedConnector
      ](
        "listConnectors",
        api.listConnectors,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.connectors().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedConnector.wrap(item))
        .provideEnvironment(r)
    def listConnectorsPaginated(
        request: zio.aws.transfer.model.ListConnectorsRequest
    ): IO[AwsError, zio.aws.transfer.model.ListConnectorsResponse.ReadOnly] =
      asyncRequestResponse[ListConnectorsRequest, ListConnectorsResponse](
        "listConnectors",
        api.listConnectors
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListConnectorsResponse.wrap)
        .provideEnvironment(r)
    def listServers(
        request: zio.aws.transfer.model.ListServersRequest
    ): ZStream[Any, AwsError, zio.aws.transfer.model.ListedServer.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListServersRequest,
        ListServersResponse,
        ListedServer
      ](
        "listServers",
        api.listServers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.servers().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.transfer.model.ListedServer.wrap(item))
        .provideEnvironment(r)
    def listServersPaginated(
        request: zio.aws.transfer.model.ListServersRequest
    ): IO[AwsError, zio.aws.transfer.model.ListServersResponse.ReadOnly] =
      asyncRequestResponse[ListServersRequest, ListServersResponse](
        "listServers",
        api.listServers
      )(request.buildAwsValue())
        .map(zio.aws.transfer.model.ListServersResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteHostKey(
      request: zio.aws.transfer.model.DeleteHostKeyRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteHostKey(request))
  def updateServer(request: zio.aws.transfer.model.UpdateServerRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServer(request))
  def updateConnector(
      request: zio.aws.transfer.model.UpdateConnectorRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConnector(request))
  def listUsers(
      request: zio.aws.transfer.model.ListUsersRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly,
    zio.aws.transfer.model.ListedUser.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listUsers(request))
  def listUsersPaginated(request: zio.aws.transfer.model.ListUsersRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def updateUser(request: zio.aws.transfer.model.UpdateUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def deleteConnector(
      request: zio.aws.transfer.model.DeleteConnectorRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteConnector(request))
  def deleteServer(
      request: zio.aws.transfer.model.DeleteServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteServer(request))
  def describeWorkflow(
      request: zio.aws.transfer.model.DescribeWorkflowRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeWorkflow(request))
  def describeProfile(
      request: zio.aws.transfer.model.DescribeProfileRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProfile(request))
  def createConnector(
      request: zio.aws.transfer.model.CreateConnectorRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConnector(request))
  def describeServer(
      request: zio.aws.transfer.model.DescribeServerRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServer(request))
  def deleteAgreement(
      request: zio.aws.transfer.model.DeleteAgreementRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAgreement(request))
  def listSecurityPolicies(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZStream[zio.aws.transfer.Transfer, AwsError, SecurityPolicyName] =
    ZStream.serviceWithStream(_.listSecurityPolicies(request))
  def listSecurityPoliciesPaginated(
      request: zio.aws.transfer.model.ListSecurityPoliciesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSecurityPoliciesPaginated(request))
  def startFileTransfer(
      request: zio.aws.transfer.model.StartFileTransferRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.StartFileTransferResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFileTransfer(request))
  def createAccess(request: zio.aws.transfer.model.CreateAccessRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccess(request))
  def describeConnector(
      request: zio.aws.transfer.model.DescribeConnectorRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConnector(request))
  def startServer(
      request: zio.aws.transfer.model.StartServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.startServer(request))
  def importSshPublicKey(
      request: zio.aws.transfer.model.ImportSshPublicKeyRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importSshPublicKey(request))
  def describeExecution(
      request: zio.aws.transfer.model.DescribeExecutionRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExecution(request))
  def updateAgreement(
      request: zio.aws.transfer.model.UpdateAgreementRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAgreement(request))
  def createUser(request: zio.aws.transfer.model.CreateUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def updateHostKey(request: zio.aws.transfer.model.UpdateHostKeyRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateHostKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHostKey(request))
  def deleteCertificate(
      request: zio.aws.transfer.model.DeleteCertificateRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCertificate(request))
  def stopServer(
      request: zio.aws.transfer.model.StopServerRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopServer(request))
  def testConnection(
      request: zio.aws.transfer.model.TestConnectionRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.TestConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testConnection(request))
  def createAgreement(
      request: zio.aws.transfer.model.CreateAgreementRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateAgreementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAgreement(request))
  def listAccesses(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
    zio.aws.transfer.model.ListedAccess.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listAccesses(request))
  def listAccessesPaginated(
      request: zio.aws.transfer.model.ListAccessesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListAccessesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessesPaginated(request))
  def describeAccess(
      request: zio.aws.transfer.model.DescribeAccessRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccess(request))
  def deleteProfile(
      request: zio.aws.transfer.model.DeleteProfileRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteProfile(request))
  def sendWorkflowStepState(
      request: zio.aws.transfer.model.SendWorkflowStepStateRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendWorkflowStepState(request))
  def startDirectoryListing(
      request: zio.aws.transfer.model.StartDirectoryListingRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDirectoryListing(request))
  def deleteAccess(
      request: zio.aws.transfer.model.DeleteAccessRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteAccess(request))
  def untagResource(
      request: zio.aws.transfer.model.UntagResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def updateCertificate(
      request: zio.aws.transfer.model.UpdateCertificateRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCertificate(request))
  def listProfiles(
      request: zio.aws.transfer.model.ListProfilesRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listProfiles(request))
  def listProfilesPaginated(
      request: zio.aws.transfer.model.ListProfilesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProfilesPaginated(request))
  def listFileTransferResults(
      request: zio.aws.transfer.model.ListFileTransferResultsRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
  ] = ZStream.serviceWithStream(_.listFileTransferResults(request))
  def listFileTransferResultsPaginated(
      request: zio.aws.transfer.model.ListFileTransferResultsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFileTransferResultsPaginated(request))
  def listExecutions(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
    zio.aws.transfer.model.ListedExecution.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listExecutions(request))
  def listExecutionsPaginated(
      request: zio.aws.transfer.model.ListExecutionsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listExecutionsPaginated(request))
  def listHostKeys(
      request: zio.aws.transfer.model.ListHostKeysRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListHostKeysResponse.ReadOnly,
    zio.aws.transfer.model.ListedHostKey.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listHostKeys(request))
  def listHostKeysPaginated(
      request: zio.aws.transfer.model.ListHostKeysRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListHostKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHostKeysPaginated(request))
  def describeUser(request: zio.aws.transfer.model.DescribeUserRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUser(request))
  def listTagsForResource(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, StreamingOutputResult[
    Any,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
    zio.aws.transfer.model.Tag.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.transfer.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def createServer(request: zio.aws.transfer.model.CreateServerRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServer(request))
  def tagResource(
      request: zio.aws.transfer.model.TagResourceRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def testIdentityProvider(
      request: zio.aws.transfer.model.TestIdentityProviderRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testIdentityProvider(request))
  def createProfile(request: zio.aws.transfer.model.CreateProfileRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProfile(request))
  def updateAccess(request: zio.aws.transfer.model.UpdateAccessRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccess(request))
  def describeHostKey(
      request: zio.aws.transfer.model.DescribeHostKeyRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHostKey(request))
  def listWorkflows(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedWorkflow.ReadOnly
  ] = ZStream.serviceWithStream(_.listWorkflows(request))
  def listWorkflowsPaginated(
      request: zio.aws.transfer.model.ListWorkflowsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWorkflowsPaginated(request))
  def deleteUser(
      request: zio.aws.transfer.model.DeleteUserRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteUser(request))
  def describeAgreement(
      request: zio.aws.transfer.model.DescribeAgreementRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAgreement(request))
  def describeSecurityPolicy(
      request: zio.aws.transfer.model.DescribeSecurityPolicyRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityPolicy(request))
  def deleteSshPublicKey(
      request: zio.aws.transfer.model.DeleteSshPublicKeyRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSshPublicKey(request))
  def importHostKey(request: zio.aws.transfer.model.ImportHostKeyRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importHostKey(request))
  def updateProfile(request: zio.aws.transfer.model.UpdateProfileRequest): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.UpdateProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProfile(request))
  def describeCertificate(
      request: zio.aws.transfer.model.DescribeCertificateRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificate(request))
  def listAgreements(
      request: zio.aws.transfer.model.ListAgreementsRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedAgreement.ReadOnly
  ] = ZStream.serviceWithStream(_.listAgreements(request))
  def listAgreementsPaginated(
      request: zio.aws.transfer.model.ListAgreementsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListAgreementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAgreementsPaginated(request))
  def listCertificates(
      request: zio.aws.transfer.model.ListCertificatesRequest
  ): ZStream[zio.aws.transfer.Transfer, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listCertificates(request))
  def listCertificatesPaginated(
      request: zio.aws.transfer.model.ListCertificatesRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCertificatesPaginated(request))
  def deleteWorkflow(
      request: zio.aws.transfer.model.DeleteWorkflowRequest
  ): ZIO[zio.aws.transfer.Transfer, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteWorkflow(request))
  def importCertificate(
      request: zio.aws.transfer.model.ImportCertificateRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ImportCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importCertificate(request))
  def createWorkflow(
      request: zio.aws.transfer.model.CreateWorkflowRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWorkflow(request))
  def listConnectors(
      request: zio.aws.transfer.model.ListConnectorsRequest
  ): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedConnector.ReadOnly
  ] = ZStream.serviceWithStream(_.listConnectors(request))
  def listConnectorsPaginated(
      request: zio.aws.transfer.model.ListConnectorsRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListConnectorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConnectorsPaginated(request))
  def listServers(request: zio.aws.transfer.model.ListServersRequest): ZStream[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListedServer.ReadOnly
  ] = ZStream.serviceWithStream(_.listServers(request))
  def listServersPaginated(
      request: zio.aws.transfer.model.ListServersRequest
  ): ZIO[
    zio.aws.transfer.Transfer,
    AwsError,
    zio.aws.transfer.model.ListServersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServersPaginated(request))
}
