package zio.aws.transfer
import zio.aws.transfer.model.ListedCertificate.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.transfer.TransferAsyncClient
import zio.aws.transfer.model.{
  DeleteUserRequest,
  ListServersRequest,
  UpdateProfileRequest,
  CreateWorkflowRequest,
  CreateAccessRequest,
  DescribeUserRequest,
  TestConnectionRequest,
  StartFileTransferRequest,
  UpdateConnectorRequest,
  DescribeServerRequest,
  StopServerRequest,
  DeleteSshPublicKeyRequest,
  UpdateAccessRequest,
  ListSecurityPoliciesRequest,
  UpdateAgreementRequest,
  ListHostKeysRequest,
  ListUsersRequest,
  ListWorkflowsRequest,
  DescribeConnectorRequest,
  DescribeAgreementRequest,
  ListTagsForResourceRequest,
  DescribeHostKeyRequest,
  CreateProfileRequest,
  ListProfilesRequest,
  ImportHostKeyRequest,
  DeleteProfileRequest,
  DeleteServerRequest,
  DeleteAgreementRequest,
  DeleteHostKeyRequest,
  CreateUserRequest,
  DescribeWorkflowRequest,
  ListExecutionsRequest,
  DescribeProfileRequest,
  DeleteAccessRequest,
  UpdateHostKeyRequest,
  DeleteConnectorRequest,
  UpdateServerRequest,
  UpdateCertificateRequest,
  ListConnectorsRequest,
  SendWorkflowStepStateRequest,
  ListAccessesRequest,
  DescribeAccessRequest,
  UntagResourceRequest,
  ListCertificatesRequest,
  DescribeSecurityPolicyRequest,
  ImportSshPublicKeyRequest,
  CreateAgreementRequest,
  UpdateUserRequest,
  CreateServerRequest,
  StartDirectoryListingRequest,
  ImportCertificateRequest,
  ListAgreementsRequest,
  DeleteWorkflowRequest,
  ListFileTransferResultsRequest,
  CreateConnectorRequest,
  DescribeExecutionRequest,
  DescribeCertificateRequest,
  DeleteCertificateRequest,
  TagResourceRequest,
  StartServerRequest,
  TestIdentityProviderRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.transfer.model.primitives.SecurityPolicyName
object TransferMock extends Mock[Transfer] {
  object DeleteHostKey extends Effect[DeleteHostKeyRequest, AwsError, Unit]
  object UpdateServer
      extends Effect[
        UpdateServerRequest,
        AwsError,
        zio.aws.transfer.model.UpdateServerResponse.ReadOnly
      ]
  object UpdateConnector
      extends Effect[
        UpdateConnectorRequest,
        AwsError,
        zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly
      ]
  object ListUsers
      extends Effect[ListUsersRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListUsersResponse.ReadOnly,
        zio.aws.transfer.model.ListedUser.ReadOnly
      ]]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.transfer.model.ListUsersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.transfer.model.UpdateUserResponse.ReadOnly
      ]
  object DeleteConnector extends Effect[DeleteConnectorRequest, AwsError, Unit]
  object DeleteServer extends Effect[DeleteServerRequest, AwsError, Unit]
  object DescribeWorkflow
      extends Effect[
        DescribeWorkflowRequest,
        AwsError,
        zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
      ]
  object DescribeProfile
      extends Effect[
        DescribeProfileRequest,
        AwsError,
        zio.aws.transfer.model.DescribeProfileResponse.ReadOnly
      ]
  object CreateConnector
      extends Effect[
        CreateConnectorRequest,
        AwsError,
        zio.aws.transfer.model.CreateConnectorResponse.ReadOnly
      ]
  object DescribeServer
      extends Effect[
        DescribeServerRequest,
        AwsError,
        zio.aws.transfer.model.DescribeServerResponse.ReadOnly
      ]
  object DeleteAgreement extends Effect[DeleteAgreementRequest, AwsError, Unit]
  object ListSecurityPolicies
      extends Stream[ListSecurityPoliciesRequest, AwsError, SecurityPolicyName]
  object ListSecurityPoliciesPaginated
      extends Effect[
        ListSecurityPoliciesRequest,
        AwsError,
        zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
      ]
  object StartFileTransfer
      extends Effect[
        StartFileTransferRequest,
        AwsError,
        zio.aws.transfer.model.StartFileTransferResponse.ReadOnly
      ]
  object CreateAccess
      extends Effect[
        CreateAccessRequest,
        AwsError,
        zio.aws.transfer.model.CreateAccessResponse.ReadOnly
      ]
  object DescribeConnector
      extends Effect[
        DescribeConnectorRequest,
        AwsError,
        zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly
      ]
  object StartServer extends Effect[StartServerRequest, AwsError, Unit]
  object ImportSshPublicKey
      extends Effect[
        ImportSshPublicKeyRequest,
        AwsError,
        zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
      ]
  object DescribeExecution
      extends Effect[
        DescribeExecutionRequest,
        AwsError,
        zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly
      ]
  object UpdateAgreement
      extends Effect[
        UpdateAgreementRequest,
        AwsError,
        zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.transfer.model.CreateUserResponse.ReadOnly
      ]
  object UpdateHostKey
      extends Effect[
        UpdateHostKeyRequest,
        AwsError,
        zio.aws.transfer.model.UpdateHostKeyResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[DeleteCertificateRequest, AwsError, Unit]
  object StopServer extends Effect[StopServerRequest, AwsError, Unit]
  object TestConnection
      extends Effect[
        TestConnectionRequest,
        AwsError,
        zio.aws.transfer.model.TestConnectionResponse.ReadOnly
      ]
  object CreateAgreement
      extends Effect[
        CreateAgreementRequest,
        AwsError,
        zio.aws.transfer.model.CreateAgreementResponse.ReadOnly
      ]
  object ListAccesses
      extends Effect[ListAccessesRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
        zio.aws.transfer.model.ListedAccess.ReadOnly
      ]]
  object ListAccessesPaginated
      extends Effect[
        ListAccessesRequest,
        AwsError,
        zio.aws.transfer.model.ListAccessesResponse.ReadOnly
      ]
  object DescribeAccess
      extends Effect[
        DescribeAccessRequest,
        AwsError,
        zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
      ]
  object DeleteProfile extends Effect[DeleteProfileRequest, AwsError, Unit]
  object SendWorkflowStepState
      extends Effect[
        SendWorkflowStepStateRequest,
        AwsError,
        zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
      ]
  object StartDirectoryListing
      extends Effect[
        StartDirectoryListingRequest,
        AwsError,
        zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly
      ]
  object DeleteAccess extends Effect[DeleteAccessRequest, AwsError, Unit]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object UpdateCertificate
      extends Effect[
        UpdateCertificateRequest,
        AwsError,
        zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly
      ]
  object ListProfiles
      extends Stream[
        ListProfilesRequest,
        AwsError,
        zio.aws.transfer.model.ListedProfile.ReadOnly
      ]
  object ListProfilesPaginated
      extends Effect[
        ListProfilesRequest,
        AwsError,
        zio.aws.transfer.model.ListProfilesResponse.ReadOnly
      ]
  object ListFileTransferResults
      extends Stream[
        ListFileTransferResultsRequest,
        AwsError,
        zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
      ]
  object ListFileTransferResultsPaginated
      extends Effect[
        ListFileTransferResultsRequest,
        AwsError,
        zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly
      ]
  object ListExecutions
      extends Effect[ListExecutionsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
        zio.aws.transfer.model.ListedExecution.ReadOnly
      ]]
  object ListExecutionsPaginated
      extends Effect[
        ListExecutionsRequest,
        AwsError,
        zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
      ]
  object ListHostKeys
      extends Effect[ListHostKeysRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.transfer.model.ListHostKeysResponse.ReadOnly,
        zio.aws.transfer.model.ListedHostKey.ReadOnly
      ]]
  object ListHostKeysPaginated
      extends Effect[
        ListHostKeysRequest,
        AwsError,
        zio.aws.transfer.model.ListHostKeysResponse.ReadOnly
      ]
  object DescribeUser
      extends Effect[
        DescribeUserRequest,
        AwsError,
        zio.aws.transfer.model.DescribeUserResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
          zio.aws.transfer.model.Tag.ReadOnly
        ]
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
      ]
  object CreateServer
      extends Effect[
        CreateServerRequest,
        AwsError,
        zio.aws.transfer.model.CreateServerResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object TestIdentityProvider
      extends Effect[
        TestIdentityProviderRequest,
        AwsError,
        zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
      ]
  object CreateProfile
      extends Effect[
        CreateProfileRequest,
        AwsError,
        zio.aws.transfer.model.CreateProfileResponse.ReadOnly
      ]
  object UpdateAccess
      extends Effect[
        UpdateAccessRequest,
        AwsError,
        zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
      ]
  object DescribeHostKey
      extends Effect[
        DescribeHostKeyRequest,
        AwsError,
        zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly
      ]
  object ListWorkflows
      extends Stream[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.transfer.model.ListedWorkflow.ReadOnly
      ]
  object ListWorkflowsPaginated
      extends Effect[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
      ]
  object DeleteUser extends Effect[DeleteUserRequest, AwsError, Unit]
  object DescribeAgreement
      extends Effect[
        DescribeAgreementRequest,
        AwsError,
        zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly
      ]
  object DescribeSecurityPolicy
      extends Effect[
        DescribeSecurityPolicyRequest,
        AwsError,
        zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
      ]
  object DeleteSshPublicKey
      extends Effect[DeleteSshPublicKeyRequest, AwsError, Unit]
  object ImportHostKey
      extends Effect[
        ImportHostKeyRequest,
        AwsError,
        zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly
      ]
  object UpdateProfile
      extends Effect[
        UpdateProfileRequest,
        AwsError,
        zio.aws.transfer.model.UpdateProfileResponse.ReadOnly
      ]
  object DescribeCertificate
      extends Effect[
        DescribeCertificateRequest,
        AwsError,
        zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly
      ]
  object ListAgreements
      extends Stream[
        ListAgreementsRequest,
        AwsError,
        zio.aws.transfer.model.ListedAgreement.ReadOnly
      ]
  object ListAgreementsPaginated
      extends Effect[
        ListAgreementsRequest,
        AwsError,
        zio.aws.transfer.model.ListAgreementsResponse.ReadOnly
      ]
  object ListCertificates
      extends Stream[ListCertificatesRequest, AwsError, ReadOnly]
  object ListCertificatesPaginated
      extends Effect[
        ListCertificatesRequest,
        AwsError,
        zio.aws.transfer.model.ListCertificatesResponse.ReadOnly
      ]
  object DeleteWorkflow extends Effect[DeleteWorkflowRequest, AwsError, Unit]
  object ImportCertificate
      extends Effect[
        ImportCertificateRequest,
        AwsError,
        zio.aws.transfer.model.ImportCertificateResponse.ReadOnly
      ]
  object CreateWorkflow
      extends Effect[
        CreateWorkflowRequest,
        AwsError,
        zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
      ]
  object ListConnectors
      extends Stream[
        ListConnectorsRequest,
        AwsError,
        zio.aws.transfer.model.ListedConnector.ReadOnly
      ]
  object ListConnectorsPaginated
      extends Effect[
        ListConnectorsRequest,
        AwsError,
        zio.aws.transfer.model.ListConnectorsResponse.ReadOnly
      ]
  object ListServers
      extends Stream[
        ListServersRequest,
        AwsError,
        zio.aws.transfer.model.ListedServer.ReadOnly
      ]
  object ListServersPaginated
      extends Effect[
        ListServersRequest,
        AwsError,
        zio.aws.transfer.model.ListServersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Transfer] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Transfer] { rts =>
        ZIO.succeed {
          new Transfer {
            val api: TransferAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Transfer = this
            def deleteHostKey(
                request: DeleteHostKeyRequest
            ): IO[AwsError, Unit] = proxy(DeleteHostKey, request)
            def updateServer(request: UpdateServerRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateServerResponse.ReadOnly
            ] = proxy(UpdateServer, request)
            def updateConnector(request: UpdateConnectorRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateConnectorResponse.ReadOnly
            ] = proxy(UpdateConnector, request)
            def listUsers(
                request: ListUsersRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.transfer.model.ListUsersResponse.ReadOnly,
              zio.aws.transfer.model.ListedUser.ReadOnly
            ]] = proxy(ListUsers, request)
            def listUsersPaginated(
                request: ListUsersRequest
            ): IO[AwsError, zio.aws.transfer.model.ListUsersResponse.ReadOnly] =
              proxy(ListUsersPaginated, request)
            def updateUser(request: UpdateUserRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateUserResponse.ReadOnly
            ] = proxy(UpdateUser, request)
            def deleteConnector(
                request: DeleteConnectorRequest
            ): IO[AwsError, Unit] = proxy(DeleteConnector, request)
            def deleteServer(request: DeleteServerRequest): IO[AwsError, Unit] =
              proxy(DeleteServer, request)
            def describeWorkflow(request: DescribeWorkflowRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeWorkflowResponse.ReadOnly
            ] = proxy(DescribeWorkflow, request)
            def describeProfile(request: DescribeProfileRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeProfileResponse.ReadOnly
            ] = proxy(DescribeProfile, request)
            def createConnector(request: CreateConnectorRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateConnectorResponse.ReadOnly
            ] = proxy(CreateConnector, request)
            def describeServer(request: DescribeServerRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeServerResponse.ReadOnly
            ] = proxy(DescribeServer, request)
            def deleteAgreement(
                request: DeleteAgreementRequest
            ): IO[AwsError, Unit] = proxy(DeleteAgreement, request)
            def listSecurityPolicies(
                request: ListSecurityPoliciesRequest
            ): ZStream[Any, AwsError, SecurityPolicyName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListSecurityPolicies, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listSecurityPoliciesPaginated(
                request: ListSecurityPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.ListSecurityPoliciesResponse.ReadOnly
            ] = proxy(ListSecurityPoliciesPaginated, request)
            def startFileTransfer(request: StartFileTransferRequest): IO[
              AwsError,
              zio.aws.transfer.model.StartFileTransferResponse.ReadOnly
            ] = proxy(StartFileTransfer, request)
            def createAccess(request: CreateAccessRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateAccessResponse.ReadOnly
            ] = proxy(CreateAccess, request)
            def describeConnector(request: DescribeConnectorRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeConnectorResponse.ReadOnly
            ] = proxy(DescribeConnector, request)
            def startServer(request: StartServerRequest): IO[AwsError, Unit] =
              proxy(StartServer, request)
            def importSshPublicKey(request: ImportSshPublicKeyRequest): IO[
              AwsError,
              zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly
            ] = proxy(ImportSshPublicKey, request)
            def describeExecution(request: DescribeExecutionRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeExecutionResponse.ReadOnly
            ] = proxy(DescribeExecution, request)
            def updateAgreement(request: UpdateAgreementRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly
            ] = proxy(UpdateAgreement, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def updateHostKey(request: UpdateHostKeyRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateHostKeyResponse.ReadOnly
            ] = proxy(UpdateHostKey, request)
            def deleteCertificate(
                request: DeleteCertificateRequest
            ): IO[AwsError, Unit] = proxy(DeleteCertificate, request)
            def stopServer(request: StopServerRequest): IO[AwsError, Unit] =
              proxy(StopServer, request)
            def testConnection(request: TestConnectionRequest): IO[
              AwsError,
              zio.aws.transfer.model.TestConnectionResponse.ReadOnly
            ] = proxy(TestConnection, request)
            def createAgreement(request: CreateAgreementRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateAgreementResponse.ReadOnly
            ] = proxy(CreateAgreement, request)
            def listAccesses(
                request: ListAccessesRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.transfer.model.ListAccessesResponse.ReadOnly,
              zio.aws.transfer.model.ListedAccess.ReadOnly
            ]] = proxy(ListAccesses, request)
            def listAccessesPaginated(request: ListAccessesRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListAccessesResponse.ReadOnly
            ] = proxy(ListAccessesPaginated, request)
            def describeAccess(request: DescribeAccessRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeAccessResponse.ReadOnly
            ] = proxy(DescribeAccess, request)
            def deleteProfile(
                request: DeleteProfileRequest
            ): IO[AwsError, Unit] = proxy(DeleteProfile, request)
            def sendWorkflowStepState(
                request: SendWorkflowStepStateRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.SendWorkflowStepStateResponse.ReadOnly
            ] = proxy(SendWorkflowStepState, request)
            def startDirectoryListing(
                request: StartDirectoryListingRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly
            ] = proxy(StartDirectoryListing, request)
            def deleteAccess(request: DeleteAccessRequest): IO[AwsError, Unit] =
              proxy(DeleteAccess, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def updateCertificate(request: UpdateCertificateRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly
            ] = proxy(UpdateCertificate, request)
            def listProfiles(request: ListProfilesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ListedProfile.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProfilesPaginated(request: ListProfilesRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListProfilesResponse.ReadOnly
            ] = proxy(ListProfilesPaginated, request)
            def listFileTransferResults(
                request: ListFileTransferResultsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFileTransferResults, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFileTransferResultsPaginated(
                request: ListFileTransferResultsRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly
            ] = proxy(ListFileTransferResultsPaginated, request)
            def listExecutions(
                request: ListExecutionsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.transfer.model.ListExecutionsResponse.ReadOnly,
              zio.aws.transfer.model.ListedExecution.ReadOnly
            ]] = proxy(ListExecutions, request)
            def listExecutionsPaginated(request: ListExecutionsRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListExecutionsResponse.ReadOnly
            ] = proxy(ListExecutionsPaginated, request)
            def listHostKeys(
                request: ListHostKeysRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.transfer.model.ListHostKeysResponse.ReadOnly,
              zio.aws.transfer.model.ListedHostKey.ReadOnly
            ]] = proxy(ListHostKeys, request)
            def listHostKeysPaginated(request: ListHostKeysRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListHostKeysResponse.ReadOnly
            ] = proxy(ListHostKeysPaginated, request)
            def describeUser(request: DescribeUserRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeUserResponse.ReadOnly
            ] = proxy(DescribeUser, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly,
              zio.aws.transfer.model.Tag.ReadOnly
            ]] = proxy(ListTagsForResource, request)
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def createServer(request: CreateServerRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateServerResponse.ReadOnly
            ] = proxy(CreateServer, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def testIdentityProvider(request: TestIdentityProviderRequest): IO[
              AwsError,
              zio.aws.transfer.model.TestIdentityProviderResponse.ReadOnly
            ] = proxy(TestIdentityProvider, request)
            def createProfile(request: CreateProfileRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateProfileResponse.ReadOnly
            ] = proxy(CreateProfile, request)
            def updateAccess(request: UpdateAccessRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateAccessResponse.ReadOnly
            ] = proxy(UpdateAccess, request)
            def describeHostKey(request: DescribeHostKeyRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly
            ] = proxy(DescribeHostKey, request)
            def listWorkflows(request: ListWorkflowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ListedWorkflow.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListWorkflowsResponse.ReadOnly
            ] = proxy(ListWorkflowsPaginated, request)
            def deleteUser(request: DeleteUserRequest): IO[AwsError, Unit] =
              proxy(DeleteUser, request)
            def describeAgreement(request: DescribeAgreementRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly
            ] = proxy(DescribeAgreement, request)
            def describeSecurityPolicy(
                request: DescribeSecurityPolicyRequest
            ): IO[
              AwsError,
              zio.aws.transfer.model.DescribeSecurityPolicyResponse.ReadOnly
            ] = proxy(DescribeSecurityPolicy, request)
            def deleteSshPublicKey(
                request: DeleteSshPublicKeyRequest
            ): IO[AwsError, Unit] = proxy(DeleteSshPublicKey, request)
            def importHostKey(request: ImportHostKeyRequest): IO[
              AwsError,
              zio.aws.transfer.model.ImportHostKeyResponse.ReadOnly
            ] = proxy(ImportHostKey, request)
            def updateProfile(request: UpdateProfileRequest): IO[
              AwsError,
              zio.aws.transfer.model.UpdateProfileResponse.ReadOnly
            ] = proxy(UpdateProfile, request)
            def describeCertificate(request: DescribeCertificateRequest): IO[
              AwsError,
              zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly
            ] = proxy(DescribeCertificate, request)
            def listAgreements(request: ListAgreementsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ListedAgreement.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAgreements, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAgreementsPaginated(request: ListAgreementsRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListAgreementsResponse.ReadOnly
            ] = proxy(ListAgreementsPaginated, request)
            def listCertificates(
                request: ListCertificatesRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCertificates, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCertificatesPaginated(request: ListCertificatesRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListCertificatesResponse.ReadOnly
            ] = proxy(ListCertificatesPaginated, request)
            def deleteWorkflow(
                request: DeleteWorkflowRequest
            ): IO[AwsError, Unit] = proxy(DeleteWorkflow, request)
            def importCertificate(request: ImportCertificateRequest): IO[
              AwsError,
              zio.aws.transfer.model.ImportCertificateResponse.ReadOnly
            ] = proxy(ImportCertificate, request)
            def createWorkflow(request: CreateWorkflowRequest): IO[
              AwsError,
              zio.aws.transfer.model.CreateWorkflowResponse.ReadOnly
            ] = proxy(CreateWorkflow, request)
            def listConnectors(request: ListConnectorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ListedConnector.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConnectors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConnectorsPaginated(request: ListConnectorsRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListConnectorsResponse.ReadOnly
            ] = proxy(ListConnectorsPaginated, request)
            def listServers(request: ListServersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.transfer.model.ListedServer.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListServers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listServersPaginated(request: ListServersRequest): IO[
              AwsError,
              zio.aws.transfer.model.ListServersResponse.ReadOnly
            ] = proxy(ListServersPaginated, request)
          }
        }
      }
    }
  }
}
