package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait AgreementStatusType {
  def unwrap: software.amazon.awssdk.services.transfer.model.AgreementStatusType
}
object AgreementStatusType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.AgreementStatusType
  ): zio.aws.transfer.model.AgreementStatusType = value match {
    case software.amazon.awssdk.services.transfer.model.AgreementStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.AgreementStatusType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.transfer.model.AgreementStatusType.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.AgreementStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.AgreementStatusType =
      software.amazon.awssdk.services.transfer.model.AgreementStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.transfer.model.AgreementStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.AgreementStatusType =
      software.amazon.awssdk.services.transfer.model.AgreementStatusType.ACTIVE
  }
  case object INACTIVE extends zio.aws.transfer.model.AgreementStatusType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.AgreementStatusType =
      software.amazon.awssdk.services.transfer.model.AgreementStatusType.INACTIVE
  }
}
