package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  As2ConnectorSecretId,
  MessageSubject,
  ProfileId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class As2ConnectorConfig(
    localProfileId: Optional[ProfileId] = Optional.Absent,
    partnerProfileId: Optional[ProfileId] = Optional.Absent,
    messageSubject: Optional[MessageSubject] = Optional.Absent,
    compression: Optional[zio.aws.transfer.model.CompressionEnum] =
      Optional.Absent,
    encryptionAlgorithm: Optional[zio.aws.transfer.model.EncryptionAlg] =
      Optional.Absent,
    signingAlgorithm: Optional[zio.aws.transfer.model.SigningAlg] =
      Optional.Absent,
    mdnSigningAlgorithm: Optional[zio.aws.transfer.model.MdnSigningAlg] =
      Optional.Absent,
    mdnResponse: Optional[zio.aws.transfer.model.MdnResponse] = Optional.Absent,
    basicAuthSecretId: Optional[As2ConnectorSecretId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.As2ConnectorConfig = {
    import As2ConnectorConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.As2ConnectorConfig
      .builder()
      .optionallyWith(
        localProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.localProfileId)
      .optionallyWith(
        partnerProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.partnerProfileId)
      .optionallyWith(
        messageSubject.map(value =>
          MessageSubject.unwrap(value): java.lang.String
        )
      )(_.messageSubject)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(encryptionAlgorithm.map(value => value.unwrap))(
        _.encryptionAlgorithm
      )
      .optionallyWith(signingAlgorithm.map(value => value.unwrap))(
        _.signingAlgorithm
      )
      .optionallyWith(mdnSigningAlgorithm.map(value => value.unwrap))(
        _.mdnSigningAlgorithm
      )
      .optionallyWith(mdnResponse.map(value => value.unwrap))(_.mdnResponse)
      .optionallyWith(
        basicAuthSecretId.map(value =>
          As2ConnectorSecretId.unwrap(value): java.lang.String
        )
      )(_.basicAuthSecretId)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.As2ConnectorConfig.ReadOnly =
    zio.aws.transfer.model.As2ConnectorConfig.wrap(buildAwsValue())
}
object As2ConnectorConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.As2ConnectorConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.As2ConnectorConfig =
      zio.aws.transfer.model.As2ConnectorConfig(
        localProfileId.map(value => value),
        partnerProfileId.map(value => value),
        messageSubject.map(value => value),
        compression.map(value => value),
        encryptionAlgorithm.map(value => value),
        signingAlgorithm.map(value => value),
        mdnSigningAlgorithm.map(value => value),
        mdnResponse.map(value => value),
        basicAuthSecretId.map(value => value)
      )
    def localProfileId: Optional[ProfileId]
    def partnerProfileId: Optional[ProfileId]
    def messageSubject: Optional[MessageSubject]
    def compression: Optional[zio.aws.transfer.model.CompressionEnum]
    def encryptionAlgorithm: Optional[zio.aws.transfer.model.EncryptionAlg]
    def signingAlgorithm: Optional[zio.aws.transfer.model.SigningAlg]
    def mdnSigningAlgorithm: Optional[zio.aws.transfer.model.MdnSigningAlg]
    def mdnResponse: Optional[zio.aws.transfer.model.MdnResponse]
    def basicAuthSecretId: Optional[As2ConnectorSecretId]
    def getLocalProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("localProfileId", localProfileId)
    def getPartnerProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("partnerProfileId", partnerProfileId)
    def getMessageSubject: ZIO[Any, AwsError, MessageSubject] =
      AwsError.unwrapOptionField("messageSubject", messageSubject)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.transfer.model.CompressionEnum] =
      AwsError.unwrapOptionField("compression", compression)
    def getEncryptionAlgorithm
        : ZIO[Any, AwsError, zio.aws.transfer.model.EncryptionAlg] =
      AwsError.unwrapOptionField("encryptionAlgorithm", encryptionAlgorithm)
    def getSigningAlgorithm
        : ZIO[Any, AwsError, zio.aws.transfer.model.SigningAlg] =
      AwsError.unwrapOptionField("signingAlgorithm", signingAlgorithm)
    def getMdnSigningAlgorithm
        : ZIO[Any, AwsError, zio.aws.transfer.model.MdnSigningAlg] =
      AwsError.unwrapOptionField("mdnSigningAlgorithm", mdnSigningAlgorithm)
    def getMdnResponse: ZIO[Any, AwsError, zio.aws.transfer.model.MdnResponse] =
      AwsError.unwrapOptionField("mdnResponse", mdnResponse)
    def getBasicAuthSecretId: ZIO[Any, AwsError, As2ConnectorSecretId] =
      AwsError.unwrapOptionField("basicAuthSecretId", basicAuthSecretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.As2ConnectorConfig
  ) extends zio.aws.transfer.model.As2ConnectorConfig.ReadOnly {
    override val localProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.localProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val partnerProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val messageSubject: Optional[MessageSubject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageSubject())
        .map(value => zio.aws.transfer.model.primitives.MessageSubject(value))
    override val compression: Optional[zio.aws.transfer.model.CompressionEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compression())
        .map(value => zio.aws.transfer.model.CompressionEnum.wrap(value))
    override val encryptionAlgorithm
        : Optional[zio.aws.transfer.model.EncryptionAlg] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAlgorithm())
      .map(value => zio.aws.transfer.model.EncryptionAlg.wrap(value))
    override val signingAlgorithm: Optional[zio.aws.transfer.model.SigningAlg] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithm())
        .map(value => zio.aws.transfer.model.SigningAlg.wrap(value))
    override val mdnSigningAlgorithm
        : Optional[zio.aws.transfer.model.MdnSigningAlg] = zio.aws.core.internal
      .optionalFromNullable(impl.mdnSigningAlgorithm())
      .map(value => zio.aws.transfer.model.MdnSigningAlg.wrap(value))
    override val mdnResponse: Optional[zio.aws.transfer.model.MdnResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mdnResponse())
        .map(value => zio.aws.transfer.model.MdnResponse.wrap(value))
    override val basicAuthSecretId: Optional[As2ConnectorSecretId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.basicAuthSecretId())
        .map(value =>
          zio.aws.transfer.model.primitives.As2ConnectorSecretId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.As2ConnectorConfig
  ): zio.aws.transfer.model.As2ConnectorConfig.ReadOnly = new Wrapper(impl)
}
