package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{
  SourceFileLocation,
  CustomStepTimeoutSeconds,
  CustomStepTarget,
  WorkflowStepName
}
import scala.jdk.CollectionConverters._
final case class CustomStepDetails(
    name: Optional[WorkflowStepName] = Optional.Absent,
    target: Optional[CustomStepTarget] = Optional.Absent,
    timeoutSeconds: Optional[CustomStepTimeoutSeconds] = Optional.Absent,
    sourceFileLocation: Optional[SourceFileLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CustomStepDetails = {
    import CustomStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CustomStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        target.map(value => CustomStepTarget.unwrap(value): java.lang.String)
      )(_.target)
      .optionallyWith(
        timeoutSeconds.map(value =>
          CustomStepTimeoutSeconds.unwrap(value): Integer
        )
      )(_.timeoutSeconds)
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CustomStepDetails.ReadOnly =
    zio.aws.transfer.model.CustomStepDetails.wrap(buildAwsValue())
}
object CustomStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CustomStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CustomStepDetails =
      zio.aws.transfer.model.CustomStepDetails(
        name.map(value => value),
        target.map(value => value),
        timeoutSeconds.map(value => value),
        sourceFileLocation.map(value => value)
      )
    def name: Optional[WorkflowStepName]
    def target: Optional[CustomStepTarget]
    def timeoutSeconds: Optional[CustomStepTimeoutSeconds]
    def sourceFileLocation: Optional[SourceFileLocation]
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getTarget: ZIO[Any, AwsError, CustomStepTarget] =
      AwsError.unwrapOptionField("target", target)
    def getTimeoutSeconds: ZIO[Any, AwsError, CustomStepTimeoutSeconds] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CustomStepDetails
  ) extends zio.aws.transfer.model.CustomStepDetails.ReadOnly {
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val target: Optional[CustomStepTarget] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.transfer.model.primitives.CustomStepTarget(value))
    override val timeoutSeconds: Optional[CustomStepTimeoutSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value =>
          zio.aws.transfer.model.primitives.CustomStepTimeoutSeconds(value)
        )
    override val sourceFileLocation: Optional[SourceFileLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFileLocation())
        .map(value =>
          zio.aws.transfer.model.primitives.SourceFileLocation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CustomStepDetails
  ): zio.aws.transfer.model.CustomStepDetails.ReadOnly = new Wrapper(impl)
}
