package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ConnectorId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConnectorRequest(connectorId: ConnectorId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest = {
    import DeleteConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteConnectorRequest.ReadOnly =
    zio.aws.transfer.model.DeleteConnectorRequest.wrap(buildAwsValue())
}
object DeleteConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteConnectorRequest =
      zio.aws.transfer.model.DeleteConnectorRequest(connectorId)
    def connectorId: ConnectorId
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest
  ) extends zio.aws.transfer.model.DeleteConnectorRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteConnectorRequest
  ): zio.aws.transfer.model.DeleteConnectorRequest.ReadOnly = new Wrapper(impl)
}
