package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAgreementResponse(
    agreement: zio.aws.transfer.model.DescribedAgreement
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse = {
    import DescribeAgreementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse
      .builder()
      .agreement(agreement.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly =
    zio.aws.transfer.model.DescribeAgreementResponse.wrap(buildAwsValue())
}
object DescribeAgreementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeAgreementResponse =
      zio.aws.transfer.model.DescribeAgreementResponse(agreement.asEditable)
    def agreement: zio.aws.transfer.model.DescribedAgreement.ReadOnly
    def getAgreement: ZIO[
      Any,
      Nothing,
      zio.aws.transfer.model.DescribedAgreement.ReadOnly
    ] = ZIO.succeed(agreement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse
  ) extends zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly {
    override val agreement: zio.aws.transfer.model.DescribedAgreement.ReadOnly =
      zio.aws.transfer.model.DescribedAgreement.wrap(impl.agreement())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAgreementResponse
  ): zio.aws.transfer.model.DescribeAgreementResponse.ReadOnly = new Wrapper(
    impl
  )
}
