package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCertificateResponse(
    certificate: zio.aws.transfer.model.DescribedCertificate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse = {
    import DescribeCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse
      .builder()
      .certificate(certificate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly =
    zio.aws.transfer.model.DescribeCertificateResponse.wrap(buildAwsValue())
}
object DescribeCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeCertificateResponse =
      zio.aws.transfer.model.DescribeCertificateResponse(certificate.asEditable)
    def certificate: zio.aws.transfer.model.DescribedCertificate.ReadOnly
    def getCertificate: ZIO[
      Any,
      Nothing,
      zio.aws.transfer.model.DescribedCertificate.ReadOnly
    ] = ZIO.succeed(certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse
  ) extends zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly {
    override val certificate
        : zio.aws.transfer.model.DescribedCertificate.ReadOnly =
      zio.aws.transfer.model.DescribedCertificate.wrap(impl.certificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeCertificateResponse
  ): zio.aws.transfer.model.DescribeCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
