package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.SecurityPolicyName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSecurityPolicyRequest(
    securityPolicyName: SecurityPolicyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest = {
    import DescribeSecurityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest
      .builder()
      .securityPolicyName(
        SecurityPolicyName.unwrap(securityPolicyName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.transfer.model.DescribeSecurityPolicyRequest.ReadOnly =
    zio.aws.transfer.model.DescribeSecurityPolicyRequest.wrap(buildAwsValue())
}
object DescribeSecurityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeSecurityPolicyRequest =
      zio.aws.transfer.model.DescribeSecurityPolicyRequest(securityPolicyName)
    def securityPolicyName: SecurityPolicyName
    def getSecurityPolicyName: ZIO[Any, Nothing, SecurityPolicyName] =
      ZIO.succeed(securityPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest
  ) extends zio.aws.transfer.model.DescribeSecurityPolicyRequest.ReadOnly {
    override val securityPolicyName: SecurityPolicyName =
      zio.aws.transfer.model.primitives
        .SecurityPolicyName(impl.securityPolicyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeSecurityPolicyRequest
  ): zio.aws.transfer.model.DescribeSecurityPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
