package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{
  CertificateChainType,
  CertificateBodyType,
  Arn,
  CertificateId,
  CertDate,
  Description,
  CertSerial
}
import scala.jdk.CollectionConverters._
final case class DescribedCertificate(
    arn: Arn,
    certificateId: Optional[CertificateId] = Optional.Absent,
    usage: Optional[zio.aws.transfer.model.CertificateUsageType] =
      Optional.Absent,
    status: Optional[zio.aws.transfer.model.CertificateStatusType] =
      Optional.Absent,
    certificate: Optional[CertificateBodyType] = Optional.Absent,
    certificateChain: Optional[CertificateChainType] = Optional.Absent,
    activeDate: Optional[CertDate] = Optional.Absent,
    inactiveDate: Optional[CertDate] = Optional.Absent,
    serial: Optional[CertSerial] = Optional.Absent,
    notBeforeDate: Optional[CertDate] = Optional.Absent,
    notAfterDate: Optional[CertDate] = Optional.Absent,
    `type`: Optional[zio.aws.transfer.model.CertificateType] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedCertificate = {
    import DescribedCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedCertificate
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(usage.map(value => value.unwrap))(_.usage)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        certificate.map(value =>
          CertificateBodyType.unwrap(value): java.lang.String
        )
      )(_.certificate)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChainType.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(activeDate.map(value => CertDate.unwrap(value): Instant))(
        _.activeDate
      )
      .optionallyWith(
        inactiveDate.map(value => CertDate.unwrap(value): Instant)
      )(_.inactiveDate)
      .optionallyWith(
        serial.map(value => CertSerial.unwrap(value): java.lang.String)
      )(_.serial)
      .optionallyWith(
        notBeforeDate.map(value => CertDate.unwrap(value): Instant)
      )(_.notBeforeDate)
      .optionallyWith(
        notAfterDate.map(value => CertDate.unwrap(value): Instant)
      )(_.notAfterDate)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedCertificate.ReadOnly =
    zio.aws.transfer.model.DescribedCertificate.wrap(buildAwsValue())
}
object DescribedCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedCertificate =
      zio.aws.transfer.model.DescribedCertificate(
        arn,
        certificateId.map(value => value),
        usage.map(value => value),
        status.map(value => value),
        certificate.map(value => value),
        certificateChain.map(value => value),
        activeDate.map(value => value),
        inactiveDate.map(value => value),
        serial.map(value => value),
        notBeforeDate.map(value => value),
        notAfterDate.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def certificateId: Optional[CertificateId]
    def usage: Optional[zio.aws.transfer.model.CertificateUsageType]
    def status: Optional[zio.aws.transfer.model.CertificateStatusType]
    def certificate: Optional[CertificateBodyType]
    def certificateChain: Optional[CertificateChainType]
    def activeDate: Optional[CertDate]
    def inactiveDate: Optional[CertDate]
    def serial: Optional[CertSerial]
    def notBeforeDate: Optional[CertDate]
    def notAfterDate: Optional[CertDate]
    def `type`: Optional[zio.aws.transfer.model.CertificateType]
    def description: Optional[Description]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getUsage
        : ZIO[Any, AwsError, zio.aws.transfer.model.CertificateUsageType] =
      AwsError.unwrapOptionField("usage", usage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.CertificateStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCertificate: ZIO[Any, AwsError, CertificateBodyType] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainType] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getActiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("activeDate", activeDate)
    def getInactiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("inactiveDate", inactiveDate)
    def getSerial: ZIO[Any, AwsError, CertSerial] =
      AwsError.unwrapOptionField("serial", serial)
    def getNotBeforeDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("notBeforeDate", notBeforeDate)
    def getNotAfterDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("notAfterDate", notAfterDate)
    def getType: ZIO[Any, AwsError, zio.aws.transfer.model.CertificateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedCertificate
  ) extends zio.aws.transfer.model.DescribedCertificate.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.transfer.model.primitives.CertificateId(value))
    override val usage: Optional[zio.aws.transfer.model.CertificateUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usage())
        .map(value => zio.aws.transfer.model.CertificateUsageType.wrap(value))
    override val status
        : Optional[zio.aws.transfer.model.CertificateStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.CertificateStatusType.wrap(value))
    override val certificate: Optional[CertificateBodyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value =>
          zio.aws.transfer.model.primitives.CertificateBodyType(value)
        )
    override val certificateChain: Optional[CertificateChainType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value =>
          zio.aws.transfer.model.primitives.CertificateChainType(value)
        )
    override val activeDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val inactiveDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.inactiveDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val serial: Optional[CertSerial] = zio.aws.core.internal
      .optionalFromNullable(impl.serial())
      .map(value => zio.aws.transfer.model.primitives.CertSerial(value))
    override val notBeforeDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notBeforeDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val notAfterDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfterDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val `type`: Optional[zio.aws.transfer.model.CertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transfer.model.CertificateType.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedCertificate
  ): zio.aws.transfer.model.DescribedCertificate.ReadOnly = new Wrapper(impl)
}
