package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Url,
  ConnectorId,
  ServiceManagedEgressIpAddress,
  Arn,
  ConnectorSecurityPolicyName,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedConnector(
    arn: Arn,
    connectorId: Optional[ConnectorId] = Optional.Absent,
    url: Optional[Url] = Optional.Absent,
    as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig] =
      Optional.Absent,
    accessRole: Optional[Role] = Optional.Absent,
    loggingRole: Optional[Role] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent,
    sftpConfig: Optional[zio.aws.transfer.model.SftpConnectorConfig] =
      Optional.Absent,
    serviceManagedEgressIpAddresses: Optional[
      Iterable[ServiceManagedEgressIpAddress]
    ] = Optional.Absent,
    securityPolicyName: Optional[ConnectorSecurityPolicyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedConnector = {
    import DescribedConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedConnector
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        connectorId.map(value => ConnectorId.unwrap(value): java.lang.String)
      )(_.connectorId)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(as2Config.map(value => value.buildAwsValue()))(
        _.as2Config
      )
      .optionallyWith(
        accessRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.accessRole)
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sftpConfig.map(value => value.buildAwsValue()))(
        _.sftpConfig
      )
      .optionallyWith(
        serviceManagedEgressIpAddresses.map(value =>
          value.map { item =>
            ServiceManagedEgressIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.serviceManagedEgressIpAddresses)
      .optionallyWith(
        securityPolicyName.map(value =>
          ConnectorSecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedConnector.ReadOnly =
    zio.aws.transfer.model.DescribedConnector.wrap(buildAwsValue())
}
object DescribedConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedConnector =
      zio.aws.transfer.model.DescribedConnector(
        arn,
        connectorId.map(value => value),
        url.map(value => value),
        as2Config.map(value => value.asEditable),
        accessRole.map(value => value),
        loggingRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sftpConfig.map(value => value.asEditable),
        serviceManagedEgressIpAddresses.map(value => value),
        securityPolicyName.map(value => value)
      )
    def arn: Arn
    def connectorId: Optional[ConnectorId]
    def url: Optional[Url]
    def as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly]
    def accessRole: Optional[Role]
    def loggingRole: Optional[Role]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly]
    def serviceManagedEgressIpAddresses
        : Optional[List[ServiceManagedEgressIpAddress]]
    def securityPolicyName: Optional[ConnectorSecurityPolicyName]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getConnectorId: ZIO[Any, AwsError, ConnectorId] =
      AwsError.unwrapOptionField("connectorId", connectorId)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
    def getAs2Config: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.As2ConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("as2Config", as2Config)
    def getAccessRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("accessRole", accessRole)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSftpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.SftpConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("sftpConfig", sftpConfig)
    def getServiceManagedEgressIpAddresses
        : ZIO[Any, AwsError, List[ServiceManagedEgressIpAddress]] =
      AwsError.unwrapOptionField(
        "serviceManagedEgressIpAddresses",
        serviceManagedEgressIpAddresses
      )
    def getSecurityPolicyName: ZIO[Any, AwsError, ConnectorSecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedConnector
  ) extends zio.aws.transfer.model.DescribedConnector.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val connectorId: Optional[ConnectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorId())
      .map(value => zio.aws.transfer.model.primitives.ConnectorId(value))
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.transfer.model.primitives.Url(value))
    override val as2Config
        : Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.as2Config())
        .map(value => zio.aws.transfer.model.As2ConnectorConfig.wrap(value))
    override val accessRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.accessRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val loggingRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
    override val sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sftpConfig())
        .map(value => zio.aws.transfer.model.SftpConnectorConfig.wrap(value))
    override val serviceManagedEgressIpAddresses
        : Optional[List[ServiceManagedEgressIpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceManagedEgressIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.ServiceManagedEgressIpAddress(item)
        }.toList
      )
    override val securityPolicyName: Optional[ConnectorSecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.ConnectorSecurityPolicyName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedConnector
  ): zio.aws.transfer.model.DescribedConnector.ReadOnly = new Wrapper(impl)
}
