package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{
  Arn,
  DateImported,
  HostKeyId,
  HostKeyType,
  HostKeyFingerprint,
  HostKeyDescription
}
import scala.jdk.CollectionConverters._
final case class DescribedHostKey(
    arn: Arn,
    hostKeyId: Optional[HostKeyId] = Optional.Absent,
    hostKeyFingerprint: Optional[HostKeyFingerprint] = Optional.Absent,
    description: Optional[HostKeyDescription] = Optional.Absent,
    `type`: Optional[HostKeyType] = Optional.Absent,
    dateImported: Optional[DateImported] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedHostKey = {
    import DescribedHostKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedHostKey
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        hostKeyId.map(value => HostKeyId.unwrap(value): java.lang.String)
      )(_.hostKeyId)
      .optionallyWith(
        hostKeyFingerprint.map(value =>
          HostKeyFingerprint.unwrap(value): java.lang.String
        )
      )(_.hostKeyFingerprint)
      .optionallyWith(
        description.map(value =>
          HostKeyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => HostKeyType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        dateImported.map(value => DateImported.unwrap(value): Instant)
      )(_.dateImported)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedHostKey.ReadOnly =
    zio.aws.transfer.model.DescribedHostKey.wrap(buildAwsValue())
}
object DescribedHostKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedHostKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedHostKey =
      zio.aws.transfer.model.DescribedHostKey(
        arn,
        hostKeyId.map(value => value),
        hostKeyFingerprint.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        dateImported.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def hostKeyId: Optional[HostKeyId]
    def hostKeyFingerprint: Optional[HostKeyFingerprint]
    def description: Optional[HostKeyDescription]
    def `type`: Optional[HostKeyType]
    def dateImported: Optional[DateImported]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getHostKeyId: ZIO[Any, AwsError, HostKeyId] =
      AwsError.unwrapOptionField("hostKeyId", hostKeyId)
    def getHostKeyFingerprint: ZIO[Any, AwsError, HostKeyFingerprint] =
      AwsError.unwrapOptionField("hostKeyFingerprint", hostKeyFingerprint)
    def getDescription: ZIO[Any, AwsError, HostKeyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, HostKeyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDateImported: ZIO[Any, AwsError, DateImported] =
      AwsError.unwrapOptionField("dateImported", dateImported)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedHostKey
  ) extends zio.aws.transfer.model.DescribedHostKey.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val hostKeyId: Optional[HostKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostKeyId())
      .map(value => zio.aws.transfer.model.primitives.HostKeyId(value))
    override val hostKeyFingerprint: Optional[HostKeyFingerprint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostKeyFingerprint())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyFingerprint(value)
        )
    override val description: Optional[HostKeyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyDescription(value)
        )
    override val `type`: Optional[HostKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.transfer.model.primitives.HostKeyType(value))
    override val dateImported: Optional[DateImported] = zio.aws.core.internal
      .optionalFromNullable(impl.dateImported())
      .map(value => zio.aws.transfer.model.primitives.DateImported(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedHostKey
  ): zio.aws.transfer.model.DescribedHostKey.ReadOnly = new Wrapper(impl)
}
