package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionAlg {
  def unwrap: software.amazon.awssdk.services.transfer.model.EncryptionAlg
}
object EncryptionAlg {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.EncryptionAlg
  ): zio.aws.transfer.model.EncryptionAlg = value match {
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES128_CBC =>
      val r = AES128_CBC
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES192_CBC =>
      val r = AES192_CBC
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES256_CBC =>
      val r = AES256_CBC
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.DES_EDE3_CBC =>
      val r = DES_EDE3_CBC
      r
    case software.amazon.awssdk.services.transfer.model.EncryptionAlg.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.UNKNOWN_TO_SDK_VERSION
  }
  case object AES128_CBC extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES128_CBC
  }
  case object AES192_CBC extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES192_CBC
  }
  case object AES256_CBC extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.AES256_CBC
  }
  case object DES_EDE3_CBC extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.DES_EDE3_CBC
  }
  case object NONE extends zio.aws.transfer.model.EncryptionAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EncryptionAlg =
      software.amazon.awssdk.services.transfer.model.EncryptionAlg.NONE
  }
}
