package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait EndpointType {
  def unwrap: software.amazon.awssdk.services.transfer.model.EndpointType
}
object EndpointType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.EndpointType
  ): zio.aws.transfer.model.EndpointType = value match {
    case software.amazon.awssdk.services.transfer.model.EndpointType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.EndpointType.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.transfer.model.EndpointType.VPC =>
      val r = VPC
      r
    case software.amazon.awssdk.services.transfer.model.EndpointType.VPC_ENDPOINT =>
      val r = VPC_ENDPOINT
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EndpointType =
      software.amazon.awssdk.services.transfer.model.EndpointType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.transfer.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EndpointType =
      software.amazon.awssdk.services.transfer.model.EndpointType.PUBLIC
  }
  case object VPC extends zio.aws.transfer.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EndpointType =
      software.amazon.awssdk.services.transfer.model.EndpointType.VPC
  }
  case object VPC_ENDPOINT extends zio.aws.transfer.model.EndpointType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.EndpointType =
      software.amazon.awssdk.services.transfer.model.EndpointType.VPC_ENDPOINT
  }
}
