package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionErrorType {
  def unwrap: software.amazon.awssdk.services.transfer.model.ExecutionErrorType
}
object ExecutionErrorType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.ExecutionErrorType
  ): zio.aws.transfer.model.ExecutionErrorType = value match {
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.PERMISSION_DENIED =>
      val r = PERMISSION_DENIED
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.CUSTOM_STEP_FAILED =>
      val r = CUSTOM_STEP_FAILED
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.THROTTLED =>
      val r = THROTTLED
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.ALREADY_EXISTS =>
      val r = ALREADY_EXISTS
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.NOT_FOUND =>
      val r = NOT_FOUND
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.BAD_REQUEST =>
      val r = BAD_REQUEST
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.TIMEOUT =>
      val r = TIMEOUT
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionErrorType.INTERNAL_SERVER_ERROR =>
      val r = INTERNAL_SERVER_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.UNKNOWN_TO_SDK_VERSION
  }
  case object PERMISSION_DENIED
      extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.PERMISSION_DENIED
  }
  case object CUSTOM_STEP_FAILED
      extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.CUSTOM_STEP_FAILED
  }
  case object THROTTLED extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.THROTTLED
  }
  case object ALREADY_EXISTS extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.ALREADY_EXISTS
  }
  case object NOT_FOUND extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.NOT_FOUND
  }
  case object BAD_REQUEST extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.BAD_REQUEST
  }
  case object TIMEOUT extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.TIMEOUT
  }
  case object INTERNAL_SERVER_ERROR
      extends zio.aws.transfer.model.ExecutionErrorType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionErrorType =
      software.amazon.awssdk.services.transfer.model.ExecutionErrorType.INTERNAL_SERVER_ERROR
  }
}
