package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait ExecutionStatus {
  def unwrap: software.amazon.awssdk.services.transfer.model.ExecutionStatus
}
object ExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.ExecutionStatus
  ): zio.aws.transfer.model.ExecutionStatus = value match {
    case software.amazon.awssdk.services.transfer.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionStatus.EXCEPTION =>
      val r = EXCEPTION
      r
    case software.amazon.awssdk.services.transfer.model.ExecutionStatus.HANDLING_EXCEPTION =>
      val r = HANDLING_EXCEPTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionStatus =
      software.amazon.awssdk.services.transfer.model.ExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.transfer.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionStatus =
      software.amazon.awssdk.services.transfer.model.ExecutionStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.transfer.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionStatus =
      software.amazon.awssdk.services.transfer.model.ExecutionStatus.COMPLETED
  }
  case object EXCEPTION extends zio.aws.transfer.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionStatus =
      software.amazon.awssdk.services.transfer.model.ExecutionStatus.EXCEPTION
  }
  case object HANDLING_EXCEPTION
      extends zio.aws.transfer.model.ExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ExecutionStatus =
      software.amazon.awssdk.services.transfer.model.ExecutionStatus.HANDLING_EXCEPTION
  }
}
