package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{DirectoryId, Role, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IdentityProviderDetails(
    url: Optional[Url] = Optional.Absent,
    invocationRole: Optional[Role] = Optional.Absent,
    directoryId: Optional[DirectoryId] = Optional.Absent,
    function: Optional[zio.aws.transfer.model.primitives.Function] =
      Optional.Absent,
    sftpAuthenticationMethods: Optional[
      zio.aws.transfer.model.SftpAuthenticationMethods
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.IdentityProviderDetails = {
    import IdentityProviderDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
      .builder()
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(
        invocationRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.invocationRole)
      .optionallyWith(
        directoryId.map(value => DirectoryId.unwrap(value): java.lang.String)
      )(_.directoryId)
      .optionallyWith(
        function.map(value =>
          zio.aws.transfer.model.primitives.Function
            .unwrap(value): java.lang.String
        )
      )(_.function)
      .optionallyWith(sftpAuthenticationMethods.map(value => value.unwrap))(
        _.sftpAuthenticationMethods
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.IdentityProviderDetails.ReadOnly =
    zio.aws.transfer.model.IdentityProviderDetails.wrap(buildAwsValue())
}
object IdentityProviderDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.IdentityProviderDetails =
      zio.aws.transfer.model.IdentityProviderDetails(
        url.map(value => value),
        invocationRole.map(value => value),
        directoryId.map(value => value),
        function.map(value => value),
        sftpAuthenticationMethods.map(value => value)
      )
    def url: Optional[Url]
    def invocationRole: Optional[Role]
    def directoryId: Optional[DirectoryId]
    def function: Optional[zio.aws.transfer.model.primitives.Function]
    def sftpAuthenticationMethods
        : Optional[zio.aws.transfer.model.SftpAuthenticationMethods]
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
    def getInvocationRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("invocationRole", invocationRole)
    def getDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("directoryId", directoryId)
    def getFunction
        : ZIO[Any, AwsError, zio.aws.transfer.model.primitives.Function] =
      AwsError.unwrapOptionField("function", function)
    def getSftpAuthenticationMethods
        : ZIO[Any, AwsError, zio.aws.transfer.model.SftpAuthenticationMethods] =
      AwsError.unwrapOptionField(
        "sftpAuthenticationMethods",
        sftpAuthenticationMethods
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ) extends zio.aws.transfer.model.IdentityProviderDetails.ReadOnly {
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.transfer.model.primitives.Url(value))
    override val invocationRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val directoryId: Optional[DirectoryId] = zio.aws.core.internal
      .optionalFromNullable(impl.directoryId())
      .map(value => zio.aws.transfer.model.primitives.DirectoryId(value))
    override val function
        : Optional[zio.aws.transfer.model.primitives.Function] =
      zio.aws.core.internal
        .optionalFromNullable(impl.function())
        .map(value => zio.aws.transfer.model.primitives.Function(value))
    override val sftpAuthenticationMethods
        : Optional[zio.aws.transfer.model.SftpAuthenticationMethods] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sftpAuthenticationMethods())
        .map(value =>
          zio.aws.transfer.model.SftpAuthenticationMethods.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.IdentityProviderDetails
  ): zio.aws.transfer.model.IdentityProviderDetails.ReadOnly = new Wrapper(impl)
}
